<?php
include 'Common.php';
class TestLogicManager {
	
	private static $GPIO_BUTTON = 'D4';
	private static $GPIO_LIGHT = 'D2';
	
	public static function test() {
		$module = new EspModule('testModule', '192.168.1.190', '00:01:02:03:04:05');
		$idModule = DaoModule::addModule($module);
		echo "ID_MODULE : $idModule\n";
		$actionButton = new Action(0, $idModule, 'button', Action::$ACTION_SENSOR, self::$GPIO_BUTTON, Action::$SENSOR_BUTTON, Action::$TYPE_LIGHT);
		$actionLight = new Action(0, $idModule, 'light', Action::$ACTION_TOGGLE, self::$GPIO_LIGHT, '', Action::$TYPE_LIGHT);
		$idActionButton = DaoAction::addAction($actionButton);
		echo "ID_ACTION_BUTTON : $idActionButton\n";
		$idActionLight = DaoAction::addAction($actionLight);
		echo "ID_ACTION_LIGHT : $idActionLight\n";
		$logicScenario = new LogicScenario('test', [$idActionButton.':0:1'], [$idActionLight], [], 0);
		$idScenario = DaoLogic::addScenario($logicScenario);
		echo "ID_SCENARIO : $idScenario\n";
		$notification = new GpioNotification($idModule, self::$GPIO_BUTTON, GpioNotification::TYPE_ISR, '1');
		LogicManager::checkIncomingNotification($notification);
		DaoModule::delModule($idModule);
		DaoLogic::delScenario($idScenario);
	}
	
}

TestLogicManager::test();