<?php
include_once 'Common.php';
class TestCronManager {
	public function testAddCron($schedule) {
		if (! CronManager::addCron ( $schedule )) {
			echo 'Fail adding line in crontab';
			return FALSE;
		}
		if (! CronManager::isCron ( $schedule )) {
			echo 'isCron failed finding line in crontab';
			return FALSE;
		}
		return TRUE;
	}
	public function testDelCron($schedule) {
		if (! CronManager::deleteCron ( $schedule )) {
			echo 'Fail deleting line in crontab';
			return FALSE;
		}
		if (CronManager::isCron ( $schedule )) {
			echo 'isCron failed, job should be removed from crontab';
			return FALSE;
		}
		return TRUE;
	}
	public static function test() {
		$module = new EspModule ( 'test', '192.168.1.1', '00:01:02:03:04:05' );
		$idModule = DaoModule::addModule ( $module );
		if ($idModule === FALSE) {
			echo 'Fail creating module';
			return FALSE;
		}
		$action = new Action ( 0, $idModule, 'test', Action::$ACTION_TOGGLE, 'D0', 1, Action::$TYPE_LIGHT );
		$idAction = DaoAction::addAction ( $action );
		if ($idAction === FALSE) {
			echo 'Fail creating action';
			return FALSE;
		}
		$schedule = new Schedule ( $idAction, Schedule::TASK_TYPE_ACTION, '* 0 * * *', 0);
		$tcm = new TestCronManager ();
		if ($tcm->testAddCron ( $schedule ) === FALSE) {
			return FALSE;
		}
		echo "addCron succeed\n";
		if (self::testDelCron ( $schedule ) === FALSE) {
			return false;
		}
		echo "delCron succeed\n";
		return TRUE;
	}
}

TestCronManager::test ();