<html>
<head>
<title>Esp Manager</title>
<meta charset='utf8' />
<link rel='stylesheet' type='text/css' href='css/style.css'>
<?php
include_once 'autoloader.php';
$id = HttpHelper::getVar ( 'id' );
if (! is_bool ( $id )) {
	$module = DaoModule::getModuleById($id);
	if($module === FALSE){
		exit(0);
	}
	echo '<script type=\'text/javascript\' />';
	echo 'var ESP_IP = \'http://' . $module->ip . '\';';
	echo '</script>';
}else{
	Logger::log('Trying to load module page without IP address !');
	exit(0);
}
?>
</head>
<body onload='load();'>
	<table class='title'>
		<tr>
			<td class='header'>ESP configuration page</td>
			<td class='status' id='statusMsg'></td>
		</tr>
	</table>
	<table id='menu'>
		<tr>
			<td>
				<ul>
					<li><a id='m1' onclick='displayPage(this.id)'>Configuration</a></li>
					<li><a id='m2' onclick='displayPage(this.id)'>GPIO
							management</a></li>
					<li><a id='m3' onclick='displayPage(this.id)'>Commands</a></li>
				</ul>
			</td>
		</tr>
	</table>
	<table id="content" style='visibility: hidden;'>
		<tr>
			<td>
				<div id="page_gpio">
					<table class='pins'>
						<tr>
							<td colspan='10' class='title'>GPIO management</td>
						</tr>
						<tr>
							<td>GPIO</td>
							<td>D0 (16)</td>
							<td>D1 (5)</td>
							<td>D2 (4)</td>
							<td>D3 (0)</td>
							<td>D4 (2)</td>
							<td>D5 (14)</td>
							<td>D6 (12)</td>
							<td>D7 (13)</td>
							<td>D8 (14)</td>
						</tr>
						<tr>
							<td>State</td>
							<td><label class='switch'> <input type='checkbox'
									id='D0' onclick='sendGpioValue(this.id)'> <span
									class='slider round'></span>
							</label></td>
							<td><label class='switch'> <input type='checkbox'
									id='D1' onclick='sendGpioValue(this.id)'> <span
									class='slider round'></span>
							</label></td>
							<td><label class='switch'> <input type='checkbox'
									id='D2' onclick='sendGpioValue(this.id)'> <span
									class='slider round'></span>
							</label></td>
							<td><label class='switch'> <input type='checkbox'
									id='D3' onclick='sendGpioValue(this.id)'> <span
									class='slider round'></span>
							</label></td>
							<td><label class='switch'> <input type='checkbox'
									id='D4' onclick='sendGpioValue(this.id)'> <span
									class='slider round'></span>
							</label></td>
							<td><label class='switch'> <input type='checkbox'
									id='D5' onclick='sendGpioValue(this.id)'> <span
									class='slider round'></span>
							</label></td>
							<td><label class='switch'> <input type='checkbox'
									id='D6' onclick='sendGpioValue(this.id)'> <span
									class='slider round'></span>
							</label></td>
							<td><label class='switch'> <input type='checkbox'
									id='D7' onclick='sendGpioValue(this.id)'> <span
									class='slider round'></span>
							</label></td>
							<td><label class='switch'> <input type='checkbox'
									id='D8' onclick='sendGpioValue(this.id)'> <span
									class='slider round'></span>
							</label></td>
						</tr>
						<tr>
							<td>Toggle</td>
							<td><button name='D0' onclick='sendGpioToggle(this.name)'>D0</button>
							</td>
							<td><button name='D1' onclick='sendGpioToggle(this.name)'>D1</button>
							</td>
							<td><button name='D2' onclick='sendGpioToggle(this.name)'>D2</button>
							</td>
							<td><button name='D3' onclick='sendGpioToggle(this.name)'>D3</button>
							</td>
							<td><button name='D4' onclick='sendGpioToggle(this.name)'>D4</button>
							</td>
							<td><button name='D5' onclick='sendGpioToggle(this.name)'>D5</button>
							</td>
							<td><button name='D6' onclick='sendGpioToggle(this.name)'>D6</button>
							</td>
							<td><button name='D7' onclick='sendGpioToggle(this.name)'>D7</button>
							</td>
							<td><button name='D8' onclick='sendGpioToggle(this.name)'>D8</button>
							</td>
						</tr>
						<tr>
							<td>Timer</td>
							<td><input class='input_text' type='text' maxlength='5'
								id='D0_time' min='0' onkeypress='sendGpioTime(event,this)'></td>
							<td><input class='input_text' type='text' maxlength='5'
								id='D1_time' min='0' onkeypress='sendGpioTime(event,this)'></td>
							<td><input class='input_text' type='text' maxlength='5'
								id='D2_time' min='0' onkeypress='sendGpioTime(event,this)'></td>
							<td><input class='input_text' type='text' maxlength='5'
								id='D3_time' min='0' onkeypress='sendGpioTime(event,this)'></td>
							<td><input class='input_text' type='text' maxlength='5'
								id='D4_time' min='0' onkeypress='sendGpioTime(event,this)'></td>
							<td><input class='input_text' type='text' maxlength='5'
								id='D5_time' min='0' onkeypress='sendGpioTime(event,this)'></td>
							<td><input class='input_text' type='text' maxlength='5'
								id='D6_time' min='0' onkeypress='sendGpioTime(event,this)'></td>
							<td><input class='input_text' type='text' maxlength='5'
								id='D7_time' min='0' onkeypress='sendGpioTime(event,this)'></td>
							<td><input class='input_text' type='text' maxlength='5'
								id='D8_time' min='0' onkeypress='sendGpioTime(event,this)'></td>
						</tr>
						<tr style='border-top: 1px solid black;'>
							<td>PWM</td>
							<td><select id='pwm_gpio'>
									<option value='D0'>D0</option>
									<option value='D1'>D1</option>
									<option value='D2'>D2</option>
									<option value='D3'>D3</option>
									<option value='D4'>D4</option>
									<option value='D5'>D5</option>
									<option value='D6'>D6</option>
									<option value='D7'>D7</option>
									<option value='D8'>D8</option>
							</select></td>
							<td colspan='8'><input type='range' min='0' max='1023'
								value='0' class='sliderRange' id='pwmSlide'
								onchange='readPwm(false)' oninput='readPwm();'></td>
						</tr>
						<tr>
							<td colspan='2'></td>
							<td>0</td>
							<td colspan='2'></td>
							<td colspan='2'><input class='input_text' type='text'
								id='pwmText' onkeypress='readPwm(event)' value='0'></td>
							<td colspan='2'></td>
							<td>1023</td>
						</tr>
						<tr>
							<td>ISR</td>
							<td>D0 (16)</td>
							<td>D1 (5)</td>
							<td>D2 (4)</td>
							<td>D3 (0)</td>
							<td>D4 (2)</td>
							<td>D5 (14)</td>
							<td>D6 (12)</td>
							<td>D7 (13)</td>
							<td>D8 (15)</td>
						</tr>
						<tr style='border-top: 1px solid black;'>
							<td><button onclick='saveIsr()'>Save</button></td>
							<td><select id='D0_isr' name='D0'
								onChange='sendGpioIsr(this.name)'>
									<option value='0'>none</option>
									<option value='1'>changing</option>
									<option value='2'>rising</option>
									<option value='3'>falling</option>
							</select></td>
							<td><select id='D1_isr' name='D1'
								onChange='sendGpioIsr(this.name)'>
									<option value='0'>none</option>
									<option value='1'>changing</option>
									<option value='2'>rising</option>
									<option value='3'>falling</option>
							</select></td>
							<td><select id='D2_isr' name='D2'
								onChange='sendGpioIsr(this.name)'>
									<option value='0'>none</option>
									<option value='1'>changing</option>
									<option value='2'>rising</option>
									<option value='3'>falling</option>
							</select></td>
							<td><select id='D3_isr' name='D3'
								onChange='sendGpioIsr(this.name)'>
									<option value='0'>none</option>
									<option value='1'>changing</option>
									<option value='2'>rising</option>
									<option value='3'>falling</option>
							</select></td>
							<td><select id='D4_isr' name='D4'
								onChange='sendGpioIsr(this.name)'>
									<option value='0'>none</option>
									<option value='1'>changing</option>
									<option value='2'>rising</option>
									<option value='3'>falling</option>
							</select></td>
							<td><select id='D5_isr' name='D5'
								onChange='sendGpioIsr(this.name)'>
									<option value='0'>none</option>
									<option value='1'>changing</option>
									<option value='2'>rising</option>
									<option value='3'>falling</option>
							</select></td>
							<td><select id='D6_isr' name='D6'
								onChange='sendGpioIsr(this.name)'>
									<option value='0'>none</option>
									<option value='1'>changing</option>
									<option value='2'>rising</option>
									<option value='3'>falling</option>
							</select></td>
							<td><select id='D7_isr' name='D7'
								onChange='sendGpioIsr(this.name)'>
									<option value='0'>none</option>
									<option value='1'>changing</option>
									<option value='2'>rising</option>
									<option value='3'>falling</option>
							</select></td>
							<td><select id='D8_isr' name='D8'
								onChange='sendGpioIsr(this.name)'>
									<option value='0'>none</option>
									<option value='1'>changing</option>
									<option value='2'>rising</option>
									<option value='3'>falling</option>
							</select></td>
						</tr>
					</table>
				</div>
				<div id="page_conf">
					<table>
						<tr>
							<td class='title' colspan='4'>Global</td>
						</tr>
						<tr>
							<td class='align-left'>MAC : <span id='mac'></span></td>
							<td class='align-left'>Channel : <span id='channel'></span></td>
							<td>Device name(4-20 caracters)</td>
							<td colspan='3'>WiFi mode</td>
						</tr>
						<tr>
							<td class='align-left'>Uptime : <span id='uptime'></span></td>
							<td class='align-left'>RSSI : <span id='rssi'>n/a</span></td>
							<td><input type='text' name='hostname' id='hostname'
								required pattern='.{4,20}'></td>
							<td>
								<table>
									<tr>
										<td>sta</td>
										<td>ap</td>
										<td>both</td>
									</tr>
									<tr>
										<td><input type='radio' name='wifimode' value='1'
											checked='checked' onchange='hideFields();'></td>
										<td><input type='radio' name='wifimode' value='2'
											onchange='hideFields();'></td>
										<td><input type='radio' name='wifimode' value='3'
											onchange='hideFields();'></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td class='align-left'>BSSID : <span id='bssid'>n/a</span></td>
							<td style='vertical-align: top'>Ds18b20 active <br> <label
								class='switch'> <input type='checkbox' id='is_temp'>
									<span class='slider round'></span>
							</label> <select id="temp_pin">
									<option value="16">D0 (16)</option>
									<option value="5">D1 (5)</option>
									<option value="4">D2 (4)</option>
									<option value="0">D3 (0)</option>
									<option value="2">D4 (2)</option>
									<option value="14">D5 (14)</option>
									<option value="12">D6 (12)</option>
									<option value="13">D7 (13)</option>
									<option value="14">D8 (15)</option>
							</select></td>
							<td style='vertical-align: top'>Serial active <br> <label
								class='switch'> <input type='checkbox' id='is_serial'>
									<span class='slider round'></span></label> <input type="number"
								id='start' />
							</td>
							<td style='text-align: center'>Disable module ?<br> <label
								class='switch'> <input type='checkbox' id='disabled'
									onclick='enable();'> <span class='slider round'></span>
							</label></td>
							<td></td>
						</tr>
					</table>
					<table>
						<tr>
							<td>
								<table id='ap_table'>
									<tr>
										<td class='title' colspan='2'>Access Point</td>
									</tr>
									<tr>
										<td>WiFi name<br>(4-20 caracters)
										</td>
										<td><input type='text' name='ap_ssid' id='ap_ssid'
											required pattern='.{4,20}'></td>
									</tr>
									<tr>
										<td>WiFi key<br>(8-20 caracters)
										</td>
										<td><input type='password' name='ap_pwd' id='ap_pwd'
											required pattern='.{8,20}'></td>
									</tr>
									<tr>
										<td>Output power<br>(0-20 dBm)
										</td>
										<td><input class='input_text' type='text' name='ap_pwr'
											id='ap_pwr' required pattern='.{0,20}'> dBm</td>
									</tr>
									<tr>
										<td>IP address<br>
										</td>
										<td><span id='ap_ip'></span></td>
									</tr>
								</table>
							</td>
							<td>
								<table id='sta_table'>
									<tr>
										<td class='title' colspan='3'>Station</td>
									</tr>
									<tr>
										<td>WiFi name<br>(4-20 caracters)
										</td>
										<td><input type='text' name='sta_ssid' id='sta_ssid'
											required pattern='.{4,20}'></td>
										<td>IP configuration</td>
									</tr>
									<tr>
										<td>WiFi key<br>(8-20 caracters)
										</td>
										<td><input type='password' name='sta_pwd' id='sta_pwd'
											required pattern='.{8,20}'></td>
										<td>
											<table>
												<tr style='width: 100%'>
													<td><input type='radio' name='ipconfig' value='0'
														onchange='hideFields();' checked='checked' id='dhcp'></td>
													<td><input type='radio' name='ipconfig' value='1'
														onchange='hideFields();'></td>
												</tr>
												<tr style='width: 100%'>
													<td>dhcp</td>
													<td>static</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td colspan='3'>
											<table id='ip_table'>
												<tr>
													<td>IP address</td>
													<td>Netmask</td>
													<td>Gateway</td>
													<td>DNS</td>
												</tr>
												<tr>
													<td><input class='input_ip' type='text' name='ipaddr'
														id='ipaddr' required
														pattern='^([0-9]{1,3}\.){3}[0-9]{1,3}$'></td>
													<td><input class='input_ip' type='text' name='netmask'
														id='netmask' required
														pattern='^([0-9]{1,3}\.){3}[0-9]{1,3}$'></td>
													<td><input class='input_ip' type='text' name='gateway'
														id='gateway' required
														pattern='^([0-9]{1,3}\.){3}[0-9]{1,3}$'></td>
													<td><input class='input_ip' type='text' name='dns'
														id='dns' required pattern='^([0-9]{1,3}\.){3}[0-9]{1,3}$'></td>
												</tr>
											</table>
										</td>
								</table>
							</td>
						</tr>
					</table>
					<table class='button_table'>
						<tr>
							<td>Apply configuration ?<br> <label class='switch'
								style='margin-left: 10%'> <input type='checkbox'
									name='to_apply' id='to_apply' checked> <span
									class='slider round'></span>
							</label>
							</td>
							<td width='30%'></td>
							<td style='text-align: center'>
								<button onclick='validate();' style='width: 100%'>SAVE</button>
							</td>
						</tr>

					</table>
				</div>
				<div id="page_cmd">
					<table>
						<tr>
							<td colspan='10' class='title'>Commands</td>
						</tr>
						<tr>
							<td>
								<button onclick='locate();' style='width: 100%'>LOCATE</button>
							</td>
							<td><button onclick='reboot();' style='width: 100%'>REBOOT</button></td>
							<td><button onclick='reset();' style='width: 100%'>RESET</button></td>
						</tr>
					</table>
				</div>
			</td>
		</tr>
	</table>
	<script type='text/javascript' src='js/script.js'></script>
</body>
</html>