var URL_API = window.location.origin + '/' + window.location.pathname + '/api';
var URL_LOGIC = URL_API + '/logic';

function showLogicForm() {
	document.getElementById('logic_description').value = '';
	var c = document.getElementsByName('conditions_selector');
	var r = document.getElementsByName('remotes_selector');
	var actions = document.getElementsByName('actions_selector');
	var logicScenarii = document.getElementsByName('logicScenarii_selector');
	for ( var index in c) {
		c[index].checked = false;
	}
	for ( var index in r) {
		r[index].checked = false;
	}
	for ( var index in actions) {
		actions[index].checked = false;
	}
	for ( var index in logicScenarii) {
		logicScenarii[index].checked = false;
	}
	if (document.getElementById("logicBox0").style.visibility != 'visible') {
		displayLogicBox(0);
	}
	document.getElementById('logic_button_span').innerHTML = 'Add';
	document.getElementById('logic_id').value = -1;
	displayPage('addLogic');
}

function modifyLogic(id) {
	var xhr = new XMLHttpRequest();
	xhr.open('GET', URL_LOGIC + '/' + id, true);
	xhr.onload = function() {
		if (xhr.status == 200) {
			var logic = JSON.parse(xhr.responseText);
			document.getElementById('logic_description').value = logic.description;
			var c = document.getElementsByName('conditions_selector');
			var r = document.getElementsByName('remotes_selector');
			var actions = document.getElementsByName('actions_selector');
			var logicScenarii = document
					.getElementsByName('logicScenarii_selector');
			for ( var i in c) {
				c[i].checked = false;
			}
			for ( var i in r) {
				r[i].checked = false;
			}
			for ( var i in actions) {
				actions[i].checked = false;
			}
			for ( var i in logicScenarii) {
				logicScenarii[i].checked = false;
			}
			if (document.getElementById("logicBox0").style.visibility != 'visible') {
				displayLogicBox(0);
			}
			for ( var i in logic.conditions) {
				for ( var j in c) {
					if (isNaN(j)) {
						console.log("NAN");
						break;
					}
					console.log(j + " <> " + c[j].value + " <==> "
							+ logic.conditions[i].actionId);
					if (c[j].value == logic.conditions[i].actionId) {
						c[j].checked = true;
						document.getElementById('logicCondition' + c[j].value).value = logic.conditions[i].condition;
						document.getElementById('logicValue' + c[j].value).value = logic.conditions[i].value;
					}
				}
			}
			for ( var i in logic.actionsId) {
				for ( var j in actions) {
					if (isNaN(j)) {
						break;
					}
					if (actions[j].value == logic.actionsId[i]) {
						actions[j].checked = true;
					}
				}
			}
			for ( var i in logic.scenariiId) {
				for ( var j in logicScenarii) {
					if (isNaN(j)) {
						break;
					}
					if (logicScenarii[j].value == logic.scenariiId[i]) {
						logicScenarii[j].checked = true;
					}
				}
			}
			document.getElementById('logic_button_span').innerHTML = 'Modify';
			document.getElementById('logic_id').value = id;
			displayPage('addLogic');
		} else {
			displayMessage('Fail getting logic scenario informations !');
		}
	};
	xhr.send();
}

function addLogic() {
	var d = document.getElementById('logic_description').value;
	var data = 'description=' + d;
	var c = document.getElementsByName('conditions_selector');
	var r = document.getElementsByName('remotes_selector');
	for ( var index in c) {
		if (c[index].checked) {
			var id = c[index].value;
			var condition = document.getElementById('logicCondition' + id).value;
			var value = document.getElementById('logicValue' + id).value;
			data += '&conditions[]=' + id + ':' + condition + ':' + value;
		}
	}
	for ( var index in r) {
		if (r[index].checked) {
			var id = r[index].value;
			var condition = 0;
			var value = document.getElementById('logicRemoteValue' + id).value;
			data += '&conditions[]=' + id + ':' + condition + ':' + value;
		}
	}
	var actions = document.getElementsByName('actions_selector');
	for ( var index in actions) {
		if (actions[index].checked) {
			data += '&actionsId[]=' + actions[index].value;
		}
	}
	var logicScenarii = document.getElementsByName('logicScenarii_selector');
	for ( var index in logicScenarii) {
		if (logicScenarii[index].checked) {
			data += '&scenariiId[]=' + logicScenarii[index].value;
		}
	}
	var xhr = new XMLHttpRequest();
	var id = document.getElementById('logic_id').value;
	if(id != -1){
		xhr.open('POST', URL_LOGIC+'/'+id, true);
	}else{
		xhr.open('POST', URL_LOGIC, true);
	}
	xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	xhr.onload = function() {
		if (xhr.status == 200) {
			location.replace("?page=logic");
		} else {
			displayMessage('Creation failed !');
		}
	};
	xhr.send(data);
}

function deleteLogic(id) {
	if (!confirm("Voulez-vous supprimer ce scenario logic ?")) {
		return false;
	}
	var xhr = new XMLHttpRequest();
	xhr.open('DELETE', URL_LOGIC + '/' + id, true);
	xhr.onload = function() {
		if (xhr.status == 200) {
			location.replace("?page=logic");
		} else {
			displayMessage('Delete failed !');
		}
	};
	xhr.send();
}

function displayLogicContent(id) {
	for ( var index in logicScenarii) {
		if (logicScenarii[index] != id) {
			document.getElementById("logic_content" + logicScenarii[index]).style.visibility = 'collapse';
			document.getElementById("logic_content" + logicScenarii[index]).style.height = '1px';
			document.getElementById("displayLogic" + logicScenarii[index]).src = "img/minimized.png";
		} else {
			if (document.getElementById("logic_content" + logicScenarii[index]).style.visibility == 'visible') {
				document.getElementById("logic_content" + logicScenarii[index]).style.visibility = 'collapse';
				document.getElementById("logic_content" + logicScenarii[index]).style.height = '1px';
				document.getElementById("displayLogic" + logicScenarii[index]).src = "img/minimized.png";
			} else {
				document.getElementById("logic_content" + logicScenarii[index]).style.visibility = 'visible';
				document.getElementById("logic_content" + logicScenarii[index]).style.height = '100%';
				document.getElementById("displayLogic" + logicScenarii[index]).src = "img/maximized.png";
			}
		}
	}
}

function executeLogic(id) {
	var xhr = new XMLHttpRequest();
	xhr.open('PUT', URL_LOGIC + '/' + id, true);
	xhr.onload = function() {
		if (xhr.status == 200) {
			displayMessage('Executing logic scenario...');
		} else {
			displayMessage('Execution failed !');
		}
	};
	xhr.send();
}

function displayLogicBox(id) {
	for (var i = 0; i < 3; i++) {
		if (i != id) {
			document.getElementById("logicBox" + i).style.visibility = 'collapse';
			document.getElementById("displayLogicImg" + i).src = "img/minimized.png";
		} else {
			if (document.getElementById("logicBox" + i).style.visibility == 'visible') {
				document.getElementById("logicBox" + i).style.visibility = 'collapse';
				document.getElementById("displayLogicImg" + i).src = "img/minimized.png";
			} else {
				document.getElementById("logicBox" + i).style.visibility = 'visible';
				document.getElementById("displayLogicImg" + i).src = "img/maximized.png";
			}
		}
	}
}
displayLogicBox(0);
displayLogicContent(-1);
