function displayTitle(id) {
	var xhr = new XMLHttpRequest();
	xhr.open('GET', 'api/module/' + id);
	xhr.onload = function() {
		if (xhr.status == 200) {
			var response = JSON.parse(xhr.responseText);
			document.getElementById("module_title").innerHTML = response.hostname;
		}
	};
	xhr.send();
}

function fillActionForm(id) {
	var xhr = new XMLHttpRequest();
	xhr.open('GET', 'api/action/' + id);
	xhr.onload = function() {
		if (xhr.status == 200) {
			var response = JSON.parse(xhr.responseText);
			document.getElementById("action_description").value = response.description;
			console.log(response.action);
			document.getElementById("action").selectedIndex = response.action;
			console.log(response.type);
			document.getElementById("type").selectedIndex = response.type;
			console.log(response.gpio);
			document.getElementById("gpio").selectedIndex = response.gpio.substring(1, 2);
			console.log(response.value);
			if(response.action == 0){
				document.getElementById("state").value = response.value;
			}else if(response.action == 2){
				document.getElementById("time").value = response.value;
			}else if (response.action == 3){
				document.getElementById("pwm").value = response.value;
			}else if (response.action == 4){
				document.getElementById("sensor").selectedIndex = response.value;
			}
			display();
		}
	};
	xhr.send();
}

function display() {
	var action0 = document.getElementById("action0");
	var action1 = document.getElementById("action1");
	var action2 = document.getElementById("action2");
	var action3 = document.getElementById("action3");
	var gpio = document.getElementById("gpio_div");
	var type = document.getElementById("type_div");
	var temp = document.getElementById("temp_div");
	var value = document.getElementById("action").options[document
			.getElementById("action").selectedIndex].value;
	var sensor = document.getElementById("sensor").options[document
			.getElementById("sensor").selectedIndex].value;
	hide = [];
	show = [];
	if (value == '0') {
		hide = [ action1, action2, action3, temp ];
		show = [ action0, gpio, type ];
	} else if (value == '1') {
		hide = [ action0, action1, action2, action3, temp ];
		show = [ gpio, type ];
	} else if (value == '2') {
		hide = [ action0, action2, action3, temp ];
		show = [ action1, gpio, type ];
	} else if (value == '3') {
		hide = [ action0, action1, action3, temp ];
		show = [ action2, gpio, type ];
	} else if (value == '4') {
		if (sensor == 0) {
			hide = [ action0, action1, action2, gpio, type ];
			show = [ action3, temp ];
		} else if (sensor == 1) {
			hide = [ action0, action1, action2, temp ];
			show = [ action3, gpio, type ];
		}else {
			hide = [ action0, action1, action2, temp, type ];
			show = [ action3, gpio ];
		}
	}
	for ( var id in hide) {
		hide[id].style.visibility = 'collapse';
		hide[id].style.height = 0;
	}
	for ( var id in show) {
		show[id].style.visibility = 'visible';
	}

}

function addAction() {
	var a = document.getElementById("action").options[document
			.getElementById("action").selectedIndex].value;
	var v = 0;
	if (a == '0') {
		v = document.getElementById("state").checked ? '1' : '0';
	} else if (a == '2') {
		v = document.getElementById("time").value;
	} else if (a == '3') {
		v = document.getElementById("pwm").value;
	} else if (a == '4') {
		v = document.getElementById("sensor").options[document
				.getElementById("sensor").selectedIndex].value;
	}
	var t = document.getElementById("type").options[document
			.getElementById("type").selectedIndex].value;
	var g;
	if (a == 4 && v == 0) {
		var g = document.getElementById("temp_selector").options[document
				.getElementById("temp_selector").selectedIndex].value;
	} else {
		var g = document.getElementById("gpio").options[document
				.getElementById("gpio").selectedIndex].value;
	}
	var a = document.getElementById("action").options[document
			.getElementById("action").selectedIndex].value;
	var d = document.getElementById("action_description").value;
	var xhr = new XMLHttpRequest();
	var id = document.getElementById("action_id").value;
	if(id == -1){
		xhr.open('POST', 'api/action');
	}else{
		xhr.open('POST', 'api/action/'+id);
	}
	xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	xhr.onload = function() {
		if (xhr.status == 200) {
			displayMessage("Action added");
			displayPage(pageList[0]);
			location.replace("?page=modules");
		} else {
			displayMessage("Fail adding action !");
		}
	};
	xhr.send("module_id=" + currentModule + "&type=" + t + "&value=" + v
			+ "&action=" + a + "&description=" + d + "&gpio=" + g);
}

display();