<?php
include 'autoloader.php';
/**
 * Main function
 *
 * @return boolean
 */
function main() {
	Logger::setLogFile ( Configuration::LOG_DIR . '/' . Configuration::LOG_FILE_API );
	Logger::setLogLevel ( Configuration::LOG_LEVEL );
	$url = HttpHelper::getUrl ();
	if (! is_bool ( $url )) {
		if (strpos ( $url, '/' ) !== FALSE) {
			return executeApi ( $url );
		} else {
			return View::includePhp ( $url );
		}
	}
	include 'php/welcome.php';
}
/**
 * Execute the request service
 * eg.
 * GET /api/user/1
 * POST /api/user
 *
 * @param string $url        	
 * @return boolean
 */
function executeApi($url) {
	$parts = explode ( '/', $url );
	if ($parts [0] !== 'api' && sizeof ( $parts ) < 2) {
		return false;
	}
	$api = $parts [1];
	$exec = 'Api' . ucfirst ( $api ) . '::execute';
	if (! @call_user_func ( $exec )) {
		Logger::log ( 'Unknown API [ ' . ucfirst ( $api ) . ' ]' );
		http_response_code ( 400 );
		return false;
	}
}
main ();
?>