<?php
class ViewScenario extends View {
	private static $PARAM_NAME = '__NAME__';
	private static $PARAM_DISPLAY = '__DISPLAY__';
	private static $PARAM_DESCRIPTION = '__DESCRIPTION__';
	private static $PARAM_EXEC_BUTTON = '__EXEC_BUTTON__';
	private static $PARAM_MODIFY_BUTTON = '__MODIFY_BUTTON__';
	private static $PARAM_DEL_BUTTON = '__DEL_BUTTON__';
	
	/**
	 * Display the javascript for sensors
	 */
	public static function displayScenarii() {
		$scenarii = DaoScenario::getScenarii ();
		$html = '';
		foreach ( $scenarii as $scenario ) {
			$actionHtml = '';
			$modulesActions = [ ];
			foreach ( $scenario->actionsId as $actionId ) {
				$action = DaoAction::getActionById ( $actionId );
				if ($action == FALSE) {
					continue;
				}
				$modulesActions [$action->moduleId] [] = $action;
			}
			foreach ( $modulesActions as $moduleId => $actions ) {
				$module = DaoModule::getModuleById ( $moduleId );
				if ($module == FALSE) {
					continue;
				}
				$actionHtml .= ViewModule::displayModuleListForScenarii ( $module, $actions );
			}
			$html .= self::processTemplate ( 'scenarii', [ 
					self::$PARAM_ID,
					self::$PARAM_DISPLAY,
					self::$PARAM_EXEC_BUTTON,
					self::$PARAM_DESCRIPTION,
					self::$PARAM_MODIFY_BUTTON,
					self::$PARAM_DEL_BUTTON,
					self::$PARAM_ACTION 
			], [ 
					$scenario->id,
					self::includeImage ( 'minimized', 'icon', 'onClick="displayScenarioContent(\'' . $scenario->id . '\')"', 'displayScenario' . $scenario->id ),
					self::includeImage ( 'execute', 'icon', 'onClick="executeScenario(\'' . $scenario->id . '\')"' ),
					$scenario->description,
					self::includeImage ( 'modify', 'icon', 'onClick="modifyScenario(\'' . $scenario->id . '\')"' ),
					self::includeImage ( 'delete', 'icon', 'onClick="deleteScenario(\'' . $scenario->id . '\')"' ),
					$actionHtml 
			] );
		}
		return $html;
	}
	/**
	 * Display the scenarii for logic
	 */
	public static function displayScenariiForLogic($scenarii=null, $checkbox=true) {
		if (! isset ( $scenarii )) {
			$scenarii = DaoScenario::getScenarii ();
		}
		$html = '';
		foreach ( $scenarii as $scenario ) {
			$actionHtml = '';
			$html .= self::processTemplate ( 'scenarii', [
					self::$PARAM_ID,
					self::$PARAM_DISPLAY,
					self::$PARAM_EXEC_BUTTON,
					self::$PARAM_DESCRIPTION,
					self::$PARAM_MODIFY_BUTTON,
					self::$PARAM_DEL_BUTTON,
					self::$PARAM_ACTION
			], [
					$scenario->id,
					'',
					self::includeImage ( 'execute' ),
					$scenario->description,
					'',
					$checkbox ? 'Add<br><input value="' . $scenario->id . '" name="logicScenarii_selector" type="checkbox">' : '',
					''
			] );
		}
		return $html;
	}
	/**
	 * Displays the necessary for Javascript
	 */
	public static function displayIds() {
		$scenarii = DaoScenario::getScenarii ();
		echo 'var scenarii = [ ';
		for($i = 0; $i < sizeof ( $scenarii ); $i ++) {
			echo $scenarii [$i]->id;
			if ($i != sizeof ( $scenarii ) - 1) {
				echo ', ';
			}
		}
		echo ' ];';
	}
}