<?php
class ViewModule extends View {
	private static $PARAM_MODIFY_BUTTON = '__MODIFY_BUTTON__';
	private static $PARAM_DISPLAY = '__DISPLAY__';
	private static $PARAM_ADD_BUTTON = '__ADD_BUTTON__';
	private static $PARAM_DEL_BUTTON = '__DEL_BUTTON__';
	
	/**
	 * Produce the HTML used to display modules
	 *
	 * @param array $modules
	 *        	<br> the list of modules to display
	 * @return string
	 */
	public static function displayModuleList($modules) {
		$html = '';
		foreach ( $modules as $module ) {
			$actionHtml = ViewAction::displayActionList ( $module->id );
			$html .= self::processTemplate ( 'module', [ 
					self::$PARAM_ID,
					self::$PARAM_DISPLAY,
					self::$PARAM_HOSTNAME,
					self::$PARAM_IP,
					self::$PARAM_MAC,
					self::$PARAM_MODIFY_BUTTON,
					self::$PARAM_ADD_BUTTON,
					self::$PARAM_DEL_BUTTON,
					self::$PARAM_ACTION 
			], [ 
					$module->id,
					self::includeImage ( 'minimized', 'icon', 'onClick="displayActions(\'' . $module->id . '\')"', 'display' . $module->id ),
					$module->hostname,
					$module->ip,
					$module->mac,
					self::includeImage ( 'modify', 'icon', 'onClick="modifyModule(\'' . $module->id . '\')"' ),
					self::includeImage ( 'add', 'icon', 'onClick="displayAction(\'' . $module->id . '\')"' ),
					self::includeImage ( 'delete', 'icon', 'onClick="deleteModule(\'' . $module->id . '\')"' ),
					$actionHtml 
			] );
		}
		return $html;
	}
	/**
	 * Produce the HTML used to display modules for scenarii
	 *
	 * @param array $modules
	 *        	<br> the list of modules to display
	 * @return string
	 */
	public static function displayModuleListForScenarii($modules, $actions, $isCheckbox = false) {
		$html = '';
		$isAction = !empty ( $actions );
		if (! is_array ( $modules )) {
			$modules = [ 
					$modules 
			];
		}
		foreach ( $modules as $module ) {
			if (empty ( $actions )) {
				$actions = [ ];
				foreach ( DaoAction::getActionsByModuleId ( $module->id ) as $action ) {
					if ($action->action != Action::$ACTION_SENSOR) {
						$actions [] = $action;
					}
				}
			}
			if (! empty ( $actions )) {
				$actionHtml = ViewAction::displayActionListForScenarii ( $module->id, $actions, $isCheckbox );
				$html .= self::processTemplate ( 'module', [ 
						self::$PARAM_ID,
						self::$PARAM_DISPLAY,
						self::$PARAM_HOSTNAME,
						self::$PARAM_IP,
						self::$PARAM_MAC,
						self::$PARAM_MODIFY_BUTTON,
						self::$PARAM_ADD_BUTTON,
						self::$PARAM_DEL_BUTTON,
						self::$PARAM_ACTION 
				], [ 
						$module->id,
						'',
						$module->hostname,
						$module->ip,
						$module->mac,
						'',
						'',
						'',
						$actionHtml 
				] );
			}
			if(!$isAction){
				$actions = null;
			}
		}
		return $html;
	}
	/**
	 * Display the javascript for sensors
	 */
	public static function displayIds() {
		$sensorActions = DaoAction::getActionSensors ();
		$temps = [ ];
		$states = [ ];
		foreach ( $sensorActions as $sensorAction ) {
			if ($sensorAction->value == Action::$SENSOR_TEMP) {
				$temps [] = $sensorAction;
			} else if ($sensorAction->value == Action::$SENSOR_STATE) {
				$states [] = $sensorAction;
			}
		}
		echo 'var sensorTemps = [ ';
		for($i = 0; $i < sizeof ( $temps ); $i ++) {
			echo '[';
			echo $temps [$i]->id;
			echo ',';
			echo $temps [$i]->gpio;
			echo ']';
			if ($i != sizeof ( $temps ) - 1) {
				echo ', ';
			}
		}
		echo ' ];';
		echo 'var sensorStates = [ ';
		for($i = 0; $i < sizeof ( $states ); $i ++) {
			echo $states [$i]->id;
			if ($i != sizeof ( $states ) - 1) {
				echo ', ';
			}
		}
		echo ' ];';
		$modules = DaoModule::getModules ();
		echo 'var modules = [ ';
		for($i = 0; $i < sizeof ( $modules ); $i ++) {
			echo $modules [$i]->id;
			if ($i != sizeof ( $modules ) - 1) {
				echo ', ';
			}
		}
		echo ' ];';
		echo 'var SENSOR_REFRESH = '.Configuration::GUI_SENSOR_REFRESH.';';
		echo 'var STATE_REFRESH = '.Configuration::GUI_STATE_REFRESH.';';
	}
}