<?php
class ViewMenu extends View {
	private static $MENU = [ 
			'Modules' => 'modules',
			'Télécommandes' => 'remotes',
			'Scenarii' => 'scenarii',
			'Logique' => 'logic', 
			'Programmation' => 'schedule'
	];
	private static $HIDDEN_PAGES = [ 
			'action',
			'scenario',
			'addRemote',
			'addLogic',
			'addSchedule'
	];
	public static function displayMenu() {
		$menu = '<ul>';
		foreach ( self::$MENU as $label => $page ) {
			$menu .= '<li>';
			$menu .= '<a id="' . $page . '" onclick="displayPage(this.id)">' . $label . '</a>';
			$menu .= '</li>';
		}
		$menu .= '</ul>';
		return $menu;
	}
	public static function displayContent() {
		echo '<table class="content" align="center">';
		echo '<tr><td>';
		foreach ( self::$MENU as $label => $page ) {
			echo '<div id="content_' . $page . '" class="content" >';
			self::includePhp ( $page );
			echo '</div>';
		}
		foreach ( self::$HIDDEN_PAGES as $page ) {
			echo '<div id="content_'.$page.'" class="content" >';
			self::includePhp ( $page );
			echo '</div>';
		}
		echo '</td></tr></table>';
	}
	public static function displayMenuJs() {
		$values = array_values ( self::$MENU );
		echo 'var pageList = [';
		for($i = 0; $i < sizeof ( $values ); $i ++) {
			echo '"' . $values [$i] . '"';
			if ($i != sizeof ( $values ) - 1) {
				echo ',';
			}
		}
		foreach ( self::$HIDDEN_PAGES as $page ) {
			echo ',"'.$page.'"';
		}
		echo '];';
		$page = HttpHelper::getVar('page');
		if(is_bool($page)){
			$page = $values [0];
		}
		echo 'var defaultPage = "' .$page. '";';
	}
}