<?php
class ViewAction extends View {
	private static $PARAM_IMG = '__IMG__';
	private static $PARAM_TYPE = '__TYPE__';
	private static $PARAM_DESCRIPTION = '__DESCRIPTION__';
	private static $PARAM_DELETE_BUTTON = '__DELETE_BUTTON__';
	private static $PARAM_MODIFY_BUTTON = '__MODIFY_BUTTON__';
	
	/**
	 * Produce the HTML used to display actions
	 *
	 * @param int $id
	 *        	<br> the module id
	 * @return string
	 */
	public static function displayActionList($id) {
		$actionHtml = '';
		$actions = DaoAction::getActionsByModuleId ( $id );
		foreach ( $actions as $action ) {
			$actionImg = '';
			if ($action->action == Action::$ACTION_STATE) {
				$actionImg .= self::includeImage ( 'state', 'icon', 'onClick="action(\'' . $action->id . '\')"' );
			} else if ($action->action == Action::$ACTION_TOGGLE) {
				$actionImg .= self::includeImage ( 'toggle', 'icon', 'onClick="action(\'' . $action->id . '\')"' );
			} else if ($action->action == Action::$ACTION_TIMED) {
				$actionImg .= self::includeImage ( 'timer', 'icon', 'onClick="action(\'' . $action->id . '\')"' );
			} else if ($action->action == Action::$ACTION_PWM) {
				$actionImg .= self::includeImage ( 'pwm', 'icon', 'onClick="action(\'' . $action->id . '\')"' );
			} else if ($action->action == Action::$ACTION_SENSOR) {
				if ($action->value == Action::$SENSOR_TEMP) {
					$actionImg = self::includeImage ( 'temp', 'icon', 'onClick="readTemp(\'' . $action->id . '\')"' );
				} else if ($action->value == Action::$SENSOR_STATE) {
					$actionImg = self::includeImage ( 'read', 'icon', 'onClick="readState(\'' . $action->id . '\')"' );
				} else if ($action->value == Action::$SENSOR_BUTTON) {
					$actionImg = self::includeImage ( 'button' );
				}
			}
			$typeImg = '';
			if ($action->action == Action::$ACTION_SENSOR) {
				if ($action->value == Action::$SENSOR_TEMP) {
					$typeImg = self::includeDiv ( $action->id, 'sensor', 'onLoad="readTemp(this.id, ' . $action->gpio . ')"' );
				} else if ($action->value == Action::$SENSOR_STATE) {
					$typeImg = self::includeImage ( 'read', 'icon', 'onClick="readState(\'' . $action->id . '\')"', $action->id );
				}
			} else {
				if ($action->type == Action::$TYPE_DOOR) {
					$typeImg = self::includeImage ( 'door', 'icon', 'onClick="action(\'' . $action->id . '\')"' );
				} else if ($action->type == Action::$TYPE_LIGHT) {
					$typeImg = self::includeImage ( 'light', 'icon', 'onClick="action(\'' . $action->id . '\')"' );
				} else if ($action->type == Action::$TYPE_VANNE) {
					$typeImg = self::includeImage ( 'water', 'icon', 'onClick="action(\'' . $action->id . '\')"' );
				}
			}
			$actionHtml .= self::processTemplate ( 'action', [ 
					self::$PARAM_ID,
					self::$PARAM_IMG,
					self::$PARAM_TYPE,
					self::$PARAM_DESCRIPTION,
					self::$PARAM_MODIFY_BUTTON,
					self::$PARAM_DELETE_BUTTON 
			], [ 
					$action->id,
					$actionImg,
					$typeImg,
					$action->description,
					self::includeImage ( 'modify', 'icon', 'onClick="modifyAction(\'' . $id . '\', \'' . $action->id . '\')"' ),
					self::includeImage ( 'delete', 'icon', 'onClick="deleteAction(\'' . $action->id . '\')"' ) 
			] );
		}
		return $actionHtml;
	}
	/**
	 * Produce the HTML used to display actions for scenarii purpose
	 *
	 * @param unknown $moduleId
	 *        	<br> the module id
	 * @param unknown $actions
	 *        	<br> the action array
	 * @param string $isCheckbox
	 *        	<br> to produce the checkbox for modification purpose
	 * @return string|boolean|mixed
	 */
	public static function displayActionListForScenarii($moduleId, $actions, $isCheckbox = false) {
		$actionHtml = '';
		if (! is_array ( $actions )) {
			$actions = [ 
					$actions 
			];
		}
		foreach ( $actions as $action ) {
			$actionImg = '';
			if ($action->action != Action::$ACTION_SENSOR) {
				$actionImg = '';
				if ($action->action == Action::$ACTION_STATE) {
					$actionImg .= self::includeImage ( 'state' );
				} else if ($action->action == Action::$ACTION_TOGGLE) {
					$actionImg .= self::includeImage ( 'toggle' );
				} else if ($action->action == Action::$ACTION_TIMED) {
					$actionImg .= self::includeImage ( 'timer' );
				} else if ($action->action == Action::$ACTION_PWM) {
					$actionImg .= self::includeImage ( 'pwm' );
				}
				$typeImg = '';
				if ($action->type == Action::$TYPE_DOOR) {
					$typeImg = self::includeImage ( 'door' );
				} else if ($action->type == Action::$TYPE_LIGHT) {
					$typeImg = self::includeImage ( 'light' );
				} else if ($action->type == Action::$TYPE_VANNE) {
					$typeImg = self::includeImage ( 'water' );
				}
				$checkBoxHtml = '';
				if ($isCheckbox) {
					$checkBoxHtml .= 'Add to scenario<br>';
					$checkBoxHtml .= '<input type="checkbox" value="' . $action->id . '" name="action_selector">';
				}
				$actionHtml .= self::processTemplate ( 'action', [ 
						self::$PARAM_ID,
						self::$PARAM_IMG,
						self::$PARAM_TYPE,
						self::$PARAM_DESCRIPTION,
						self::$PARAM_MODIFY_BUTTON,
						self::$PARAM_DELETE_BUTTON 
				], [ 
						$action->id,
						$actionImg,
						$typeImg,
						$action->description,
						'',
						$checkBoxHtml 
				] );
			}
		}
		return $actionHtml;
	}
	/**
	 * Produce the HTML used to display sensors for logic purpose
	 *
	 * @param int $id
	 *        	<br> the module id
	 * @return string
	 */
	public static function displaySensorsForLogic() {
		$actionHtml = '';
		$actions = DaoAction::getActions ();
		foreach ( $actions as $action ) {
			if ($action->isSensor ()) {
				$actionImg = '';
				$conditions = '<select id="logicCondition' . $action->id . '">';
				$indexes;
				$values = '<input type="number" id="logicValue' . $action->id . '" value="0" ';
				if ($action->value == Action::$SENSOR_TEMP) {
					$actionImg = self::includeImage ( 'temp' );
					$indexes = LogicEventTemp::CONDITIONS;
				} else if ($action->value == Action::$SENSOR_STATE) {
					$actionImg = self::includeImage ( 'read' );
					$indexes = LogicEventState::CONDITIONS;
					$values .= 'min="0" max="1"';
				} else if ($action->value == Action::$SENSOR_BUTTON) {
					$actionImg = self::includeImage ( 'button' );
					$indexes = LogicEventButton::CONDITIONS;
					$values .= 'min="0" max="1"';
				}
				foreach ( $indexes as $index ) {
					$conditions .= '<option value="' . $index . '">' . LogicEvent::CONDITIONS [$index] . '</option>';
				}
				$conditions .= '</select>';
				$values .= '>';
				$forms = $conditions . $values;
				$checkBoxHtml = 'Add<br><input type="checkbox" value="' . $action->id . '" name="conditions_selector">';
				$actionHtml .= self::processTemplate ( 'action', [ 
						self::$PARAM_ID,
						self::$PARAM_IMG,
						self::$PARAM_TYPE,
						self::$PARAM_DESCRIPTION,
						self::$PARAM_MODIFY_BUTTON,
						self::$PARAM_DELETE_BUTTON 
				], [ 
						$action->id,
						$actionImg,
						$forms,
						$action->description,
						'',
						$checkBoxHtml 
				] );
			}
		}
		return $actionHtml;
	}
	public static function displaySensorFromEvent(LogicEvent $event) {
		$actionHtml = '';
		$actionImg = '';
		$action = DaoAction::getActionById ( $event->actionId );
		if(is_a($event, 'LogicEventRemote')){
			$actionImg = self::includeImage ( 'remote' );
		}else{
			if ($action->value == Action::$SENSOR_TEMP) {
				$actionImg = self::includeImage ( 'temp' );
			} else if ($action->value == Action::$SENSOR_STATE) {
				$actionImg = self::includeImage ( 'read' );
			} else if ($action->value == Action::$SENSOR_BUTTON) {
				$actionImg = self::includeImage ( 'button' );
			}
		}
		$conditions = LogicEvent::CONDITIONS [$event->condition];
		$value = $event->value;
		$forms = $conditions . ' ' . $value;
		$actionHtml .= self::processTemplate ( 'action', [ 
				self::$PARAM_ID,
				self::$PARAM_IMG,
				self::$PARAM_TYPE,
				self::$PARAM_DESCRIPTION,
				self::$PARAM_MODIFY_BUTTON,
				self::$PARAM_DELETE_BUTTON 
		], [ 
				$event->actionId,
				$actionImg,
				$forms,
				!is_bool($action) ? $action->description : '',
				'',
				'' 
		] );
		return $actionHtml;
	}
	/**
	 * Produce the HTML used to display sensors for logic purpose
	 *
	 * @param int $id
	 *        	<br> the module id
	 * @return string
	 */
	public static function displayActionsForLogic() {
		$actionHtml = '';
		$actions = DaoAction::getActions ();
		foreach ( $actions as $action ) {
			if (! $action->isSensor ()) {
				$actionImg = '';
				if ($action->action == Action::$ACTION_STATE) {
					$actionImg .= self::includeImage ( 'state' );
				} else if ($action->action == Action::$ACTION_TOGGLE) {
					$actionImg .= self::includeImage ( 'toggle' );
				} else if ($action->action == Action::$ACTION_TIMED) {
					$actionImg .= self::includeImage ( 'timer' );
				} else if ($action->action == Action::$ACTION_PWM) {
					$actionImg .= self::includeImage ( 'pwm' );
				}
				$typeImg = '';
				if ($action->type == Action::$TYPE_DOOR) {
					$typeImg = self::includeImage ( 'door' );
				} else if ($action->type == Action::$TYPE_LIGHT) {
					$typeImg = self::includeImage ( 'light' );
				} else if ($action->type == Action::$TYPE_VANNE) {
					$typeImg = self::includeImage ( 'water' );
				}
				$checkBoxHtml = 'Add<br><input type="checkbox" value="' . $action->id . '" name="actions_selector">';
				$actionHtml .= self::processTemplate ( 'action', [ 
						self::$PARAM_ID,
						self::$PARAM_IMG,
						self::$PARAM_TYPE,
						self::$PARAM_DESCRIPTION,
						self::$PARAM_MODIFY_BUTTON,
						self::$PARAM_DELETE_BUTTON 
				], [ 
						$action->id,
						$actionImg,
						$typeImg,
						$action->description,
						'',
						$checkBoxHtml 
				] );
			}
		}
		return $actionHtml;
	}
	/**
	 * Display HTML to choose GPIO
	 *
	 * @return string
	 */
	public static function displayGpioSelector() {
		$str = '<select id="gpio" name="gpio">';
		foreach ( Action::$ACTIONS_ESP_GPIO as $gpio ) {
			$str .= '<option value="' . $gpio . '"';
			if ($gpio == Action::$ACTIONS_ESP_GPIO [0]) {
				$str .= ' selected';
			}
			$str .= '>' . $gpio . '</option>';
		}
		$str .= '</select>';
		return $str;
	}
	/**
	 * Display HTML to choose GPIO
	 *
	 * @return string
	 */
	public static function displayTempSelector() {
		$str = '<select id="temp_selector" name="temp_selector">';
		for($i = 0; $i < 128; $i ++) {
			$str .= '<option value="' . $i . '"';
			if ($i == 0) {
				$str .= ' selected';
			}
			$str .= '>' . $i . '</option>';
		}
		$str .= '</select>';
		return $str;
	}
	/**
	 * Display HTML to choose action
	 *
	 * @return string
	 */
	public static function displayActions() {
		$str = '<select id="action" name="action" onchange="display()">';
		$i = 0;
		foreach ( Action::$ACTIONS_NAMES as $name ) {
			$str .= '<option value="' . $i ++ . '"';
			if ($i == 1) {
				$str .= ' selected';
			}
			$str .= '>' . $name . '</option>';
		}
		$str .= '</select>';
		return $str;
	}
	/**
	 * Display HTML to choose type
	 *
	 * @return string
	 */
	public static function displayTypes() {
		$str = '<select id="type" name="type"	onchange="display()">';
		$i = 0;
		foreach ( Action::$ACTIONS_TYPES as $type ) {
			$str .= '<option value="' . $i ++ . '"';
			if ($i == 1) {
				$str .= ' selected';
			}
			$str .= '>' . $type . '</option>';
		}
		$str .= '</select>';
		return $str;
	}
	/**
	 * Display HTML to choose sensor
	 *
	 * @return string
	 */
	public static function displaySensors() {
		$str = '<select id="sensor" name="sensor"	onchange="display()">';
		$i = 0;
		foreach ( Action::$ACTIONS_SENSORS as $sensor ) {
			$str .= '<option value="' . $i ++ . '"';
			if ($i == 1) {
				$str .= ' selected';
			}
			$str .= '>' . $sensor . '</option>';
		}
		$str .= '</select>';
		return $str;
	}
	/**
	 * Display the first module of the list
	 */
	public static function displayCurrentModule() {
		$modules = DaoModule::getModules ();
		if (! empty ( $modules )) {
			echo 'var currentModule=' . $modules [0]->id . ';';
		}
	}
}