<?php
class View {
	protected static $PARAM_ID = '__ID__';
	protected static $PARAM_IP = '__IP__';
	protected static $PARAM_MAC = '__MAC__';
	protected static $PARAM_HOSTNAME = '__HOSTNAME__';
	protected static $PARAM_ACTION = '__ACTION__';
	private static $HTML_FOLDER = 'html';
	private static $JS_FOLDER = 'js';
	private static $CSS_FOLDER = 'css';
	private static $IMG_FOLDER = 'img';
	/**
	 * Process a template
	 * @param string $name
	 * @param array|string $pattern
	 * @param array|string $replacement
	 * @return boolean|mixed
	 */
	protected static function processTemplate($name, $pattern, $replacement) {
		$name = strpos ( $name, '.html' ) === FALSE ? $name . '.html' : $name;
		$filename = self::$HTML_FOLDER . '/' . $name;
		if (! is_file ( $filename )) {
			Logger::warning ( 'Template ' . $filename . ' does not exists' );
			return false;
		}
		if (is_array ( $pattern )) {
			for($i = 0; $i < sizeof ( $pattern ); $i ++) {
				$pattern [$i] = empty ( $pattern [$i] ) ? '@@' : '@' . $pattern [$i] . '@';
			}
		}else{
			$pattern = empty ( $pattern ) ? '@@' : '@' . $pattern . '@';
		}
		$html = preg_replace ( $pattern, $replacement, file_get_contents ( $filename ) );
		return $html;
	}
	/**
	 * Include the script file, must be called inside <script> tag
	 * @param string $name
	 * <br> the script name
	 * @return boolean
	 */
	public static function includeJavascript($name){
		$name = strpos ( $name, '.js' ) === FALSE ? $name . '.js' : $name;
		$filename = self::$JS_FOLDER . '/' . $name;
		if (! is_file ( $filename )) {
			Logger::warning ( 'Javascript ' . $filename . ' does not exists' );
			return false;
		}
		echo file_get_contents($filename);
		return true;
	}
	/**
	 * Include the css file, must be called inside <style> tag
	 * @param string $name
	 * <br> the CSS sheet name
	 * @return boolean|string
	 */
	public static function includeCss($name){
		$name = strpos ( $name, '.css' ) === FALSE ? $name . '.css' : $name;
		$filename = self::$CSS_FOLDER . '/' . $name;
		if (! is_file ( $filename )) {
			Logger::warning ( 'Css ' . $filename . ' does not exists' );
			return false;
		}
		echo file_get_contents($filename);
		return true;
	}
	/**
	 * Generate the img tag with base64
	 * @param string $name
	 * <br> the image name
	 * @return boolean
	 */
	public static function includeImage($name, $class='', $js='', $id=''){
		$name = strpos ( $name, '.png' ) === FALSE ? $name . '.png' : $name;
		$filename = self::$IMG_FOLDER . '/' . $name;
		if (! is_file ( $filename )) {
			Logger::warning ( 'Image ' . $filename . ' does not exists' );
			return false;
		}
		$html = '<img';
		$html .= ' src="data:image/jpeg;base64,'.base64_encode(file_get_contents($filename)).'"';
		if(!empty($id)){
			$html .= ' id="'.$id.'"';
		}
		if(!empty($class)){
			$html .= ' class='.$class;
		}
		if(!empty($js)){
			$html .= ' '.$js;
		}
		$html .= ' />';
		return $html;
	}
	
	/**
	 * Generate the img tag with base64
	 * @param string $name
	 * <br> the image name
	 * @return boolean
	 */
	public static function includeDiv($id, $class='', $js=''){
		$html = '<div id="'.$id.'"';
		if(!empty($class)){
			$html .= ' class='.$class;
		}
		if(!empty($js)){
			$html .= ' '.$js;
		}
		$html .= ' ></div>';
		return $html;
	}
	/**
	 * Includes a php file
	 * @param string $name
	 * <br> the PHP file
	 * @return unknown|boolean
	 */
	public static function includePhp($name){
		$name = strpos ( $name, '.php' ) === FALSE ? $name . '.php' : $name;
		$filename = 'php/'.$name;
		if(is_file($filename)){
			return include $filename;
		}
		Logger::error('File '.$filename.' does not exists');
		return FALSE;
	}
}