<?php
class LogicScenario {
	public $id, $description, $conditions, $actionsId, $scenariiId;
	public function __construct($description, $conditions, $actionsId, $scenariiId, $id = 0) {
		$this->id = $id;
		$this->conditions = ! empty ( $conditions ) ? $conditions : [ ];
		$this->description = $description;
		$this->actionsId = ! empty ( $actionsId ) ? $actionsId : [ ];
		$this->scenariiId = ! empty ( $scenariiId ) ? $scenariiId : [ ];
	}
	/**
	 * Return TRUE if every conditions are TRUE
	 *
	 * @return boolean
	 */
	public function checkConditions(GpioNotification $validate = null) {
		foreach ( $this->conditions as $condition ) {
			if (isset ( $validate )) {
				if (! RemoteModule::isRemote ( $condition->actionId )) {
					// Condition is not a remote					
					$action = DaoAction::getActionById ( $condition->actionId );
					if ($action !== FALSE && $action->getSensorType () == Action::$SENSOR_BUTTON && $action->gpio == $validate->gpio) {
						continue;
					}
				}
				// Condition is a remote
				if ($condition->checkCondition ($validate->gpio)) {
					// Remote button pressed ($validate->gpio) is correct
					continue;
				}
			}
			if (! $condition->checkCondition ()) {
				return FALSE;
			}
		}
		return TRUE;
	}
	/**
	 * Return TRUE if every conditions are TRUE regardless of buttons
	 *
	 * @return boolean
	 */
	public function checkConditionsWithoutButtons() {
		foreach ( $this->conditions as $condition ) {
			if (! is_a ( $condition, 'LogicEventButton' ) && ! is_a ( $condition, 'LogicEventRemote' )) {
				if (! $condition->checkCondition ()) {
					return FALSE;
				}
			}
		}
		return TRUE;
	}
}