<?php
class GpioNotification {
	const TYPE_STATE = 0;
	const TYPE_PWM = 1;
	const TYPE_ISR = 2;
	const TYPE_SERIAL = 3;
	public $id, $idModule, $gpio, $type, $value, $date;
	public function __construct($idModule, $gpio, $type, $value, $date=0, $id=0) {
		$this->id = $id;
		$this->idModule = $idModule;
		$this->gpio = $gpio;
		$this->type = $type;
		$this->value = $value;
		$this->date = $date;
	}
	
	public function isState(){
		return $this->type == self::TYPE_STATE;
	}
	
	public function isPwm(){
		return $this->type == self::TYPE_PWM;
	}
	
	public function isIsr(){
		return $this->type == self::TYPE_ISR;
	}
	
	public function isSerial(){
		return $this->type == self::TYPE_SERIAL;
	}
}
