<?php
class Action {
	public static $ACTIONS_NAMES = [ 
			'state',
			'toggle',
			'timer',
			'pwm',
			'sensor'
	];
	public static $ACTIONS_TYPES = [ 
			'light',
			'vanne',
			'door' 
	];
	public static $ACTIONS_SENSORS = [ 
			'temp',
			'state',
			'button'
	];
	public static $ACTIONS_ESP_GPIO = [ 
			'D0',
			'D1',
			'D2',
			'D3',
			'D4',
			'D5',
			'D6',
			'D7',
			'D8' 
	];
	public static $ACTION_STATE = 0;
	public static $ACTION_TOGGLE = 1;
	public static $ACTION_TIMED = 2;
	public static $ACTION_PWM = 3;
	public static $ACTION_SENSOR = 4;
	public static $TYPE_LIGHT = 0;
	public static $TYPE_VANNE = 1;
	public static $TYPE_DOOR = 2;
	public static $SENSOR_TEMP = 0;
	public static $SENSOR_STATE = 1;
	public static $SENSOR_BUTTON = 2;
	public $id, $moduleId, $description, $action, $gpio, $value, $type;
	public function __construct($id, $moduleId, $description, $action, $gpio, $value, $type) {
		$this->id = $id;
		$this->moduleId = $moduleId;
		$this->description = $description;
		$this->action = $action;
		$this->gpio = $gpio;
		$this->value = $value;
		$this->type = $type;
	}
	/**
	 * Return the action type, can be:
	 * <ul>
	 * <li>0 for state
	 * <li>1 for toggle</li>
	 * <li>2 for timer</li>
	 * <li>3 for pwm</li>
	 * <li>4 for sensor</li>
	 * </ul>
	 *
	 * @return int
	 */
	public function getActionType() {
		return $this->action;
	}
	/**
	 * True if action is a sensor
	 *
	 * @return boolean
	 */
	public function isSensor() {
		return $this->action == self::$ACTION_SENSOR;
	}
	/**
	 * In case of sensor, return the type otherwise FALSE :
	 * <ul>
	 * <li>0 for temp
	 * <li>1 for state</li>
	 * <li>2 for button</li>
	 * </ul>
	 *
	 * @return int|boolean
	 */
	public function getSensorType() {
		if ($this->action == self::$ACTION_SENSOR) {
			return $this->value;
		}
		return FALSE;
	}
}