<?php
class SocketHelper {
	/**
	 * Return the socket with options setted
	 *
	 * @return boolean|resource
	 */
	public static function getMulticastSocket($mip) {
		$socket = socket_create ( AF_INET, SOCK_DGRAM, SOL_UDP );
		$grpparms = array (
				"group" => $mip 
		);
		if (socket_set_option ( $socket, IPPROTO_IP, MCAST_JOIN_GROUP, $grpparms ) === FALSE || socket_set_option ( $socket, SOL_SOCKET, SO_REUSEADDR, 1 ) === FALSE) {
			Logger::warning ( 'Fail setting multicast options' );
			return false;
		}
		return $socket;
	}
	/**
	 * Sends a string to the given ip and port
	 *
	 * @param string $paket
	 *        	<br> the string to send
	 * @param string $ip
	 *        	<br> the ip to send to
	 * @param int $port
	 *        	<br> the port to send to
	 * @param resource $socket        	
	 * @return boolean|resource
	 */
	public static function sendUdpPacket($packet, $mip, $mport, &$socket) {
		if ($socket === FALSE) {
			Logger::warning ( 'Problem with the given socket' );
			return FALSE;
		}
		$ret = socket_sendto ( $socket, $packet, strlen ( $packet ), 0, $mip, $mport ) !== FALSE;
		if ($ret === FALSE) {
			Logger::error ( 'Fail sending multicast packet to ' . $mip . ':' . $mport . ' [ ' . $packet . ' ]' );
			return FALSE;
		}
		Logger::debug ( 'Sending multicast packet to ' . $mip . ':' . $mport . ' [ ' . $packet . ' ]' );
		return TRUE;
	}
	/**
	 * Read on the socket
	 *
	 * @param resource $socket
	 *        	<br> the socket to read from
	 * @param string $sip
	 *        	<br> the source ip address
	 * @param strin $sport
	 *        	<br> the source port
	 * @param int $timeout
	 *        	<br> the timeout in microseconds
	 * @param int $size
	 *        	<br> the buffer size
	 * @return string|boolean
	 */
	public static function readUdpPacket(&$socket, &$sip = null, &$sport = null, $timeout = 0, $size = 2048) {
		$buffer = '';
		if ($timeout > 0) {
			socket_set_nonblock ( $socket );
			$start = microtime ( true );
			$remaining = 0;
			while ( $remaining < $timeout ) {
				socket_recvfrom ( $socket, $buffer, $size, 0, $sip, $sport );
				if (! empty ( $buffer )) {
					break;
				}
				$remaining = (microtime ( true ) - $start)*1000;
				usleep ( 10 );
			}
			socket_set_block ( $socket );
		} else {
			if (socket_recvfrom ( $socket, $buffer, $size, 0, $from, $port ) !== FALSE) {
				return FALSE;
			}
		}
		return trim($buffer);
	}
}