<?php
class DaoScenario extends Dao {
	protected static $DB_FILE = 'scenarii.db';
	private static $INDEX_ID = 0;
	private static $INDEX_DESCRIPTION = 1;
	private static $INDEX_ACTIONS_ID = 2;
	/**
	 * Return all scnearii in db
	 *
	 * @return Scneario[]
	 */
	public static function getScenarii() {
		$dbScenarii = self::getValues ();
		if (empty ( $dbScenarii )) {
			return [ ];
		}
		$scenarii = [ ];
		foreach ( $dbScenarii as $dbScenario ) {
			$scenarii [] = new Scenario ( $dbScenario [self::$INDEX_DESCRIPTION], $dbScenario [self::$INDEX_ACTIONS_ID], $dbScenario [self::$INDEX_ID] );
		}
		return $scenarii;
	}
	/**
	 * Return the scenario corresponding to the given ID
	 *
	 * @param string $id
	 *        	<br> The scenario id
	 * @return Scenario|boolean <br>The scenario object or false
	 */
	public static function getScenarioByid($id) {
		$dbScenarii = self::getValues ();
		if (! empty ( $dbScenarii )) {
			foreach ( $dbScenarii as $dbScenario ) {
				if ($dbScenario [self::$INDEX_ID] == $id) {
					return new Scenario ( $dbScenario [self::$INDEX_DESCRIPTION], $dbScenario [self::$INDEX_ACTIONS_ID], $dbScenario [self::$INDEX_ID] );
				}
			}
		}
		Logger::warning ( 'Scenario with id ' . $id . ' does not exists' );
		return FALSE;
	}
	/**
	 * Add the scenario to the db
	 *
	 * @param Scenario $scenario        	
	 * @return boolean
	 */
	public static function addScenario(Scenario $scenario) {
		$dbScenarii = self::getValues ();
		foreach ( $scenario->actionsId as $action_id ) {
			if (DaoAction::getActionById ( $action_id ) === FALSE) {
				return FALSE;
			}
		}
		$id = self::getNextId ();
		$dbScenarii [] = [ 
				self::$INDEX_ID => $id,
				self::$INDEX_DESCRIPTION => $scenario->description,
				self::$INDEX_ACTIONS_ID => $scenario->actionsId 
		];
		self::write ( $dbScenarii );
		return $id;
	}
	/**
	 * Modify a scenario
	 * @param Scenario $scenario
	 * @return boolean|int
	 */
	public static function modifyScenario(Scenario $scenario) {
		$dbScenarii = self::getValues ();
		foreach ( $scenario->actionsId as $action_id ) {
			if (DaoAction::getActionById ( $action_id ) === FALSE) {
				return FALSE;
			}
		}
		for($i = 0; $i < sizeof ( $dbScenarii); $i ++) {
			if ($dbScenarii[$i] [self::$INDEX_ID] == $scenario->id) {
				$dbScenarii[$i] [self::$INDEX_DESCRIPTION] = $scenario->description;
				$dbScenarii[$i] [self::$INDEX_ACTIONS_ID] = $scenario->actionsId;
				self::write ( $dbScenarii );
				Logger::debug ( "Modifying scenario with id " . $id );
				return $id;
			}
		}
		return FALSE;
	}
	/**
	 * Remove all given action from any scenario using it
	 * @param number $actionId
	 * @return boolean
	 */
	public static function removeActionFromScenarii($actionId) {
		$dbScenarii = self::getValues ();
		if (empty ( $dbScenarii )) {
			return TRUE;
		}
		for($i = 0; $i < sizeof ( $dbScenarii ); $i ++) {
			for($j = 0; $j < sizeof ( $dbScenarii [$i] [self::$INDEX_ACTIONS_ID] ); $j ++) {
				if ($dbScenarii [$i] [self::$INDEX_ACTIONS_ID] == $actionId) {
					Logger::debug ( 'Deleting action ' . $actionId . ' in scenario with id ' . $dbScenarii [$i] [self::$INDEX_ID] );
					array_splice ( $dbScenarii [$i] [self::$INDEX_ACTIONS_ID], $j, 1 );
				}
			}
		}
		self::write ( $dbScenarii );
		return TRUE;
	}
	/**
	 * Delete an existing scenario
	 *
	 * @param int $id        	
	 * @return boolean
	 */
	public static function delScenario($id) {
		$dbScenarii = self::getValues ();
		if (empty ( $dbScenarii )) {
			return FALSE;
		}
		for($i = 0; $i < sizeof ( $dbScenarii ); $i ++) {
			if ($dbScenarii [$i] [self::$INDEX_ID] == $id) {
				DaoSchedule::removeSchedulesWithScenario($id);
				array_splice ( $dbScenarii, $i, 1 );
				self::write ( $dbScenarii );
				Logger::debug ( "Deleting scenario with id " . $id );
				return true;
			}
		}
		Logger::warning ( 'Scenario ' . $id . ' does not exists in db' );
		return FALSE;
	}
}