<?php
class DaoNotification extends Dao {
	private static $INDEX_ID = 0;
	private static $INDEX_MODULE_ID = 1;
	private static $INDEX_GPIO = 2;
	private static $INDEX_TYPE = 3;
	private static $INDEX_VALUE = 4;
	private static $INDEX_DATE = 5;
	
	/**
	 * Return the last HELO notification date related
	 * to the given module id
	 *
	 * @param string $id        	
	 * @return string|boolean
	 */
	public static function getLastHelo($id) {
		if(empty($id)){
			Logger::warning('Cannot get notifications with empty id');
			return FALSE;
		}
		$notifications = self::getValues ( self::getHeloDbFile () );
		return empty ( $notifications [$id] ) ? FALSE : $notifications [$id];
	}
	
	/**
	 * Stores an HELO notification
	 *
	 * @param string $mac        	
	 */
	public static function storeHelo($id) {
		if(empty($id)){
			Logger::warning('Cannot store notification with empty id');
			return FALSE;
		}
		$notifications = self::getValues ( self::getHeloDbFile () );
		$notifications [$id] = time ();
		self::write ( $notifications, self::getHeloDbFile () );
		return TRUE;
	}
	
	/**
	 * Return all gpio notifications for the given module id
	 *
	 * @param string $id        	
	 */
	public static function getGpioNotificationsByModule($id) {
		if (DaoModule::getModuleById ( $id ) === FALSE) {
			return FALSE;
		}
		$db = self::getGpioDbFile ( $id );
		$notificationDb = self::getValues ( $db );
		$notifications = [];
		foreach ($notificationDb as $notification){
			$notifications[] = new GpioNotification($notification[self::$INDEX_MODULE_ID], $notification[self::$INDEX_GPIO], $notification[self::$INDEX_TYPE], $notification[self::$INDEX_VALUE], $notification[self::$INDEX_DATE], $notification[self::$INDEX_ID]);
		}
		return $notifications;
	}
	
	/**
	 * Stores a gpio notification
	 * @param GpioNotification $notification
	 * @return boolean|EspModule[]
	 */
	public static function storeGpioModification(GpioNotification $notification) {
		if (DaoModule::getModuleById ( $notification->idModule ) === FALSE) {
			return FALSE;
		}
		$db = self::getGpioDbFile ( $notification->idModule );
		$notificationDb = self::getValues ( $db );
		$id = self::getNextId ( $db );
		$notificationDb [] = [ 
				self::$INDEX_ID => $id,
				self::$INDEX_MODULE_ID => $notification->idModule,
				self::$INDEX_GPIO => $notification->gpio,
				self::$INDEX_TYPE => $notification->type,
				self::$INDEX_VALUE => $notification->value,
				self::$INDEX_DATE => time () 
		];
		if(sizeof($notificationDb) > Configuration::NOTIFICATION_DB_SIZE){
			array_splice($notificationDb, 0, sizeof($notificationDb) - Configuration::NOTIFICATION_DB_SIZE);
		}
		self::write ( $notificationDb, $db );
		return $id;
	}
	private static function getHeloDbFile() {
		return 'helo.db';
	}
	private static function getGpioDbFile($id) {
		return $id . '-gpio-notifications.db';
	}
}