<?php
class DaoAction extends Dao {
	protected static $DB_FILE = 'action.db';
	private static $INDEX_ID = 0;
	private static $INDEX_MODULE_ID = 1;
	private static $INDEX_DESCRIPTION = 2;
	private static $INDEX_ACTION = 3;
	private static $INDEX_GPIO = 4;
	private static $INDEX_VALUE = 5;
	private static $INDEX_TYPE = 6;
	/**
	 * Return the action corresponding to the given id
	 *
	 * @param int $id
	 *        	<br> The action id
	 * @return array|boolean <br>The action object or false
	 */
	public static function getActions() {
		$dbActions = self::getValues ();
		if (empty ( $dbActions )) {
			return [ ];
		}
		$actions = [ ];
		foreach ( $dbActions as $dbAction ) {
			$actions [] = new Action ( $dbAction [self::$INDEX_ID], $dbAction [self::$INDEX_MODULE_ID], $dbAction [self::$INDEX_DESCRIPTION], $dbAction [self::$INDEX_ACTION], $dbAction [self::$INDEX_GPIO], $dbAction [self::$INDEX_VALUE], $dbAction [self::$INDEX_TYPE] );
		}
		return $actions;
	}
	/**
	 * Return all actions corresponding to sensors
	 *
	 * @return EspModule|boolean <br>The action object or false
	 */
	public static function getActionSensors() {
		$dbActions = self::getValues ();
		if (empty ( $dbActions )) {
			return [ ];
		}
		$actions = [ ];
		foreach ( $dbActions as $dbAction ) {
			if ($dbAction [self::$INDEX_ACTION] == Action::$ACTION_SENSOR) {
				$actions [] = new Action ( $dbAction [self::$INDEX_ID], $dbAction [self::$INDEX_MODULE_ID], $dbAction [self::$INDEX_DESCRIPTION], $dbAction [self::$INDEX_ACTION], $dbAction [self::$INDEX_GPIO], $dbAction [self::$INDEX_VALUE], $dbAction [self::$INDEX_TYPE] );
			}
		}
		return $actions;
	}
	/**
	 * Return the action corresponding to the given id
	 *
	 * @param int $id
	 *        	<br> The action id
	 * @return array|boolean <br>The action object or false
	 */
	public static function getActionById($id) {
		$dbActions = self::getValues ();
		if (! empty ( $dbActions )) {
			foreach ( $dbActions as $dbAction ) {
				if ($dbAction [self::$INDEX_ID] == $id) {
					return new Action ( $dbAction [self::$INDEX_ID], $dbAction [self::$INDEX_MODULE_ID], $dbAction [self::$INDEX_DESCRIPTION], $dbAction [self::$INDEX_ACTION], $dbAction [self::$INDEX_GPIO], $dbAction [self::$INDEX_VALUE], $dbAction [self::$INDEX_TYPE] );
				}
			}
		}
		Logger::warning ( 'Action ' . $id . ' does not exists' );
		return FALSE;
	}
	/**
	 * Return all actions associated to the given module id
	 *
	 * @param int $id
	 *        	<br> The module id
	 * @return Array|boolean
	 */
	public static function getActionsByModuleId($moduleId) {
		if (DaoModule::getModuleById ( $moduleId ) === FALSE) {
			Logger::warning ( 'Module with id ' . $moduleId . ' does not exits' );
			return FALSE;
		}
		$dbActions = self::getValues ();
		if (empty ( $dbActions )) {
			Logger::warning ( 'Database is empty' );
			return [];
		}
		$actions = [ ];
		foreach ( $dbActions as $dbAction ) {
			if ($dbAction [self::$INDEX_MODULE_ID] == $moduleId) {
				$actions [] = new Action ( $dbAction [self::$INDEX_ID], $dbAction [self::$INDEX_MODULE_ID], $dbAction [self::$INDEX_DESCRIPTION], $dbAction [self::$INDEX_ACTION], $dbAction [self::$INDEX_GPIO], $dbAction [self::$INDEX_VALUE], $dbAction [self::$INDEX_TYPE] );
			}
		}
		return $actions;
	}
	/**
	 * Add the action to the db if not already in
	 *
	 * @param Action $action        	
	 * @return int|boolean
	 */
	public static function addAction(Action $action) {
		if (DaoModule::getModuleById ( $action->moduleId ) !== FALSE) {
			$actions = self::getValues ();
			$id = self::getNextId ();
			$actions [] = [ 
					self::$INDEX_ID => $id,
					self::$INDEX_MODULE_ID => $action->moduleId,
					self::$INDEX_DESCRIPTION => $action->description,
					self::$INDEX_ACTION => $action->action,
					self::$INDEX_GPIO => $action->gpio,
					self::$INDEX_VALUE => $action->value,
					self::$INDEX_TYPE => $action->type 
			];
			self::write ( $actions );
			Logger::debug ( "Adding action with id " . $id );
			return $id;
		}
		Logger::warning ( 'Module ' . $action->moduleId . ' does not exist' );
		return FALSE;
	}
	/**
	 * Modify an existing action
	 *
	 * @param int $id
	 * @return boolean
	 */
	public static function modifyAction(Action $action) {
		$dbActions = self::getValues ();
		if (empty ( $dbActions )) {
			return FALSE;
		}
		for($i = 0; $i < sizeof ( $dbActions ); $i ++) {
			if ($dbActions [$i] [self::$INDEX_ID] == $action->id) {
				$dbActions [$i] [self::$INDEX_DESCRIPTION] = $action->description;
				$dbActions [$i] [self::$INDEX_GPIO] = $action->gpio;
				$dbActions [$i] [self::$INDEX_TYPE] = $action->type;
				$dbActions [$i] [self::$INDEX_VALUE] = $action->value;
				$dbActions [$i] [self::$INDEX_ACTION] = $action->action;
				self::write ( $dbActions );
				Logger::debug ( "Modifying action with id " . $id );
				return $id;
			}
		}
		Logger::info ( 'Action ' . $id . ' does not exists in db' );
		return FALSE;
	}
	/**
	 * Delete an existing action
	 *
	 * @param int $id        	
	 * @return boolean
	 */
	public static function delAction($id) {
		$dbActions = self::getValues ();
		if (empty ( $dbActions )) {
			return FALSE;
		}
		for($i = 0; $i < sizeof ( $dbActions ); $i ++) {
			if ($dbActions [$i] [self::$INDEX_ID] == $id) {
				array_splice ( $dbActions, $i, 1 );
				Logger::debug('01');
				DaoScenario::removeActionFromScenarii($id);
				Logger::debug('02');
				DaoLogic::removeActionFromLogicScenarii($id);
				Logger::debug('03');
				DaoSchedule::removeSchedulesWithActions($id);
				Logger::debug('04');
				self::write ( $dbActions );
				Logger::debug ( "Deleting action with id " . $id );
				return true;
			}
		}
		Logger::info ( 'Action ' . $id . ' does not exists in db' );
		return FALSE;
	}
}