<?php 
abstract class Dao{
		
	protected static $DB_FOLDER = 'db';
	private static $INDEX_ID = 0;
	private static $INDEX_VALUES = 1;
	/**
	 * Write the data in Json to the file
	 * @param mixed $data
	 * @return number
	 */
	protected static function write($data, $db=null){
		if(!isset($db)){
			$db = static::$DB_FILE;
		}
		$db_file = self::$DB_FOLDER.'/'.$db;
		if(!is_file($db_file)){
			touch($db_file);
		}
		$content = self::getDatabase($db);
		$content[self::$INDEX_VALUES] = $data;
		return file_put_contents($db_file, json_encode($content));
	}
	/**
	 * Read the data in Json
	 * @return array|mixed
	 */
	protected static function read($db=null){
		if(!isset($db)){
			$db = static::$DB_FILE;
		}
		$db_file = self::$DB_FOLDER.'/'.$db;
		if(!is_file($db_file)){
			touch($db_file);
		}
		$content = file_get_contents($db_file);
		if(empty($content)){
			return array();
		}
		return json_decode($content, true);
	}
	
	/**
	 * Return database with index and values
	 * @return EspModule[]
	 */
	protected static function getDatabase($db=null) {
		$db_file = self::read ($db);
		if (empty ( $db_file )) {
			return [self::$INDEX_ID=>0,self::$INDEX_VALUES=>array()];
		}
		return $db_file;
	}
	
	/**
	 * Return all values in db
	 * @return EspModule[]
	 */
	protected static function getValues($db=null) {
		$db_file= self::getDatabase($db);
		return $db_file[self::$INDEX_VALUES];
	}
	
	/**
	 * Return all values in db
	 * @return EspModule[]
	 */
	protected static function getNextId($db=null) {
		if(!isset($db)){
			$db = static::$DB_FILE;
		}
		$db_file = self::$DB_FOLDER.'/'.$db;
		if(!is_file($db_file)){
			touch($db_file);
		}
		$content = self::getDatabase($db);
		$id = $content[self::$INDEX_ID]++;
		if(file_put_contents($db_file, json_encode($content)) === FALSE){
			Logger::error('Fail writting to file '.$db_file);
			return FALSE;
		}
		return $id;
	}
}
?>