<?php
class LogicManager {
	public static function checkIncomingNotification(GpioNotification $notification) {
		Logger::debug('Incoming notification from module id '.$notification->idModule.' on GPIO '.$notification->gpio);
		$logicScenarii = [ ];
		$validate = null;
		if ($notification->isSerial ()) {
			if (RemoteModule::isRemote($notification->idModule)) {
				// Notification comes from a remote (R123456:1)
				$serial = substr ( $notification->idModule, 1 );
				$remote = DaoRemote::getRemoteBySerial( $serial );
				if ($remote === FALSE) {
					return FALSE;
				}
				Logger::debug('Button '.$notification->gpio.' of remote '.$serial.' pressed');
				$notification->idModule = $remote->id;
				$validate = $notification;
				// Find all scenarii with this remote
				foreach ( DaoLogic::getScenariiContainingConditions ( $remote->id ) as $logicScenario ) {
					foreach ( $logicScenario->conditions as $condition ) {
						if ($condition->actionId == $remote->id) {
							if ($notification->gpio == $condition->value) {
								$logicScenarii [] = $logicScenario;
							}
						}
					}
				}
			}
		} else {
			// Notification comes from an EspModule
			$actions = DaoAction::getActionsByModuleId ( $notification->idModule );
			Logger::debug('Found '.sizeof($actions).' actions for module '.$notification->idModule);
			foreach ( $actions as $action ) {
				// If action is a sensor and GPIO are corresponding
				if ($action->isSensor () && $action->gpio == $notification->gpio) {
					if ($notification->isIsr () && $action->getSensorType () == Action::$SENSOR_BUTTON) {
						// If notification is ISR & Action type is a button
						Logger::debug('Action id '.$action->id.' is a button pressed, adding to validate actions');
						$validate = $notification;
					}
					$logicScenarii = DaoLogic::getScenariiContainingConditions ( $action->id );
					break;
				}
			}
		}
		Logger::debug('Found '.sizeof($logicScenarii). ' logic scenario(s) to check');
		$toExecute = [];
		foreach ( $logicScenarii as $logicScenario ) {
			// Checking condition first
			if ($logicScenario->checkConditions ( $validate )) {
				$toExecute[] = $logicScenario;
			}
		}
		foreach ( $toExecute as $logicScenario ) {
			// Executing scenarii second 
			self::threadScenarioExecution ( $logicScenario );
		}
	}
	/**
	 * Execute the given scenario
	 *
	 * @param LogicScenario $logicScenario        	
	 */
	public static function executeScenario(LogicScenario $logicScenario) {
		Logger::info ( 'Executing logic scenario ' . $logicScenario->id );
		$actionsId = $logicScenario->actionsId;
		if (! empty ( $logicScenario->scenariiId )) {
			foreach ( $logicScenario->scenariiId as $scenarioId ) {
				$scenario = DaoScenario::getScenarioByid ( $scenarioId );
				$actionsId = array_merge ( $actionsId, $scenario->actionsId );
			}
		}
		foreach ( $actionsId as $actionId ) {
			$action = DaoAction::getActionById ( $actionId );
			ActionManager::getActionValue ( $action );
		}
	}
	
	/**
	 * Used to thread the scenario execution for minimum reaction time
	 *
	 * @param LogicScenario $logicScenario        	
	 */
	public static function threadScenarioExecution(LogicScenario $logicScenario) {
		$pid = pcntl_fork ();
		if ($pid == - 1) {
			// Fork failed
			Logger::fatal ( "Fail forking" );
			return FALSE;
		} else if ($pid) {
			return TRUE;
		} else {
			Logger::debug ( 'Forking scenario ' . $logicScenario->id . ' execution' );
			self::executeScenario ( $logicScenario );
			exit ( 0 );
		}
		return TRUE;
	}
}