<?php
class ActionManager {
	public static function getActionValue($action, $toJson = true) {
		if ($action !== FALSE) {
			$ip = DaoModule::getModuleById ( $action->moduleId )->ip;
			$json = FALSE;
			if ($action->action == Action::$ACTION_STATE) {
				// Should be like { "state" : 1 }
				$json = ModuleManager::modifyGpioState ( $ip, $action->gpio, $action->value );
				if ($json !== FALSE) {
					return self::readState ( $json, $toJson );
				}
			} else if ($action->action == Action::$ACTION_TOGGLE) {
				// Should be like { "state" : 1 }
				$json = ModuleManager::toggleGpioState ( $ip, $action->gpio );
				if ($json !== FALSE) {
					return self::readState ( $json, $toJson );
				}
			} else if ($action->action == Action::$ACTION_TIMED) {
				// Should be like { "state" : 1 }
				$json = ModuleManager::timeGpioState ( $ip, $action->gpio, $action->value );
				if ($json !== FALSE) {
					return self::readState ( $json, $toJson );
				}
			} else if ($action->action == Action::$ACTION_PWM) {
				// Should be like { "state" : 350 }
				$json = ModuleManager::pwmGpio ( $ip, $action->gpio, $action->value );
				if ($json !== FALSE) {
					return $toJson ? self::readState ( $json, $toJson ) : self::readState ( $json, $toJson )->state;
				}
			} else if ($action->action == Action::$ACTION_SENSOR) {
				if ($action->value == Action::$SENSOR_TEMP) {
					// Should be like { "temperatures" : [ 28.00000,40.50000 ] }
					$json = ModuleManager::readTemp ( $ip );
					if ($json !== FALSE) {
						return self::readTemp ( $json, $action->gpio, $toJson );
					}
				} else if ($action->value == Action::$SENSOR_STATE || $action->value == Action::$SENSOR_BUTTON) {
					// Should be like { "state" : 1 }
					$json = ModuleManager::getGpioState ( $ip, $action->gpio );
					if ($json !== FALSE) {
						return self::readState ( $json, $toJson );
					}
				} else {
					Logger::warning ( 'Unknown sensor type' );
				}
			} else {
				Logger::warning ( 'Unknown action' );
			}
		}
		return FALSE;
	}
	/**
	 * Return 0 or 1 according to state
	 * 
	 * @param string $json        	
	 * @param bool $toJson        	
	 * @return string|boolean
	 */
	private static function readState($json, $toJson) {
		if ($toJson) {
			return $json;
		}
		$result = json_decode ( $json );
		return $result->state;
	}
	private static function readTemp($json, $index) {
		$result = json_decode ( $json );
		return isset ( $result->temperatures [$index] ) ? $result->temperatures [$index] : FALSE;
	}
}