<?php
class ApiScenario extends Api {
	private static $PARAM_MODULE_ID = 'id';
	private static $PARAM_DESCRIPTION = 'description';
	private static $PARAM_ACTIONS = 'actions';
	/**
	 * Executed during GET
	 */
	static function executeGet() {
		$url = self::getCleanUrl ();
		if ($url === '') {
			$scenarii = DaoScenario::getScenarii ();
			return self::response ( self::$CODE_OK, json_encode ( $scenarii ) );
		} else if (is_numeric ( $url )) {
			$scenario = DaoScenario::getScenarioById ( $url );
			if ($scenario !== FALSE) {
				return self::response ( self::$CODE_OK, json_encode ( $scenario ) );
			}
		} else {
			logger::warning ( 'Bad request' );
		}
		return self::response ();
	}
	/**
	 * Executed during POST
	 */
	static function executePost() {
		$url = self::getCleanUrl ();
		$scenarioId = null;
		if (! empty ( $url )) {
			$scenarioId = $url;
		}
		$description = HttpHelper::postVar ( self::$PARAM_DESCRIPTION );
		$actions = HttpHelper::postVar ( self::$PARAM_ACTIONS );
		if (is_bool ( $description )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_DESCRIPTION );
			return self::response ();
		}
		if (is_bool ( $actions )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_ACTIONS );
			return self::response ();
		}
		$scenario = new Scenario ( $description, $actions, $scenarioId );
		if(isset($scenarioId)){
			$scenarioId = DaoScenario::modifyScenario($scenario);
		}else{
			$scenarioId = DaoScenario::addScenario($scenario);
		}
		if ($id === FALSE) {
			return self::response ();
		}
		return self::response ( self::$CODE_OK, '{ id : ' . $id . ' }' );
	}
	/**
	 * Executed during PUT
	 */
	static function executePut() {
		$url = self::getCleanUrl ();
		if (empty ( $url ) && $url !== '0') {
			Logger::warning ( 'Missing parameter' );
			return self::response ();
		}
		$scenarioId = self::getUrlParameter ( 0 );
		if ($senarioId !== FALSE) {
			$scenario = DaoScenario::getScenarioByid ( $scenarioId );
			Logger::info ( 'Executing scenario ' . $scenarioId );
			if ($scenario !== FALSE) {
				$oks = [ ];
				$errors = [ ];
				foreach ( $scenario->actionsId as $actionId ) {
					$action = DaoAction::getActionById ( $actionId );
					if ($action !== FALSE) {
						if (ActionManager::getActionValue ( $action ) !== FALSE) {
							$oks [] = $actionId;
						} else {
							$errors [] = $actionId;
						}
					}
					usleep ( 50 );
				}
				$response = '{ "ok" : [';
				for($i = 0; $i < sizeof ( $oks ); $i ++) {
					$response .= $oks [$i];
					if ($i < sizeof ( $oks ) - 1) {
						$response .= ',';
					}
				}
				$response .= '], "error" : [';
				for($i = 0; $i < sizeof ( $errors ); $i ++) {
					$response .= $errors [$i];
					if ($i < sizeof ( $errors ) - 1) {
						$response .= ',';
					}
				}
				$response .= '] }';
				return self::response ( self::$CODE_OK, $response );
			}
		}
		return self::response ();
	}
	/**
	 * Executed during DELETE
	 */
	static function executeDelete() {
		$url = self::getCleanUrl ();
		if (is_bool ( $url )) {
			return self::response ();
		}
		if (is_numeric ( $url )) {
			$scenario = DaoScenario::delScenario ( $url );
			if ($scenario !== FALSE) {
				return self::response ( self::$CODE_OK );
			}
		}
		return self::response ();
	}
}