<?php
class ApiNotification extends Api {
	private static $URL_LOG = 'log';
	private static $PARAM_TYPE = 'type';
	private static $PARAM_GPIO = 'gpio';
	/**
	 * Executed during GET
	 */
	static function executeGet() {
		$url = self::getCleanUrl ();
		if (! empty ( $url )) {
			if (is_numeric ( $url )) {
				$last_seen = DaoNotification::getLastHelo ( $url );
				if ($last_seen !== FALSE) {
					$date = date ( 'd/m/Y H:i:s', $last_seen );
					return self::response ( self::$CODE_OK, json_encode ( $date ) );
				}
			} else {
				$url = self::getUrlParameter ( 0 );
				$id = self::getUrlParameter ( 1 );
				if ($url === self::$URL_LOG) {
					$notifications = DaoNotification::getGpioNotificationsByModule ( $id );
					if ($notifications !== FALSE) {
						$type = HttpHelper::getVar ( self::$PARAM_TYPE );
						if($type > 3 || $type < 0){
							logger::warning("Wrong value for type");
							return self::response ();
						}
						if (! is_bool ( $type )) {
							for($i = 0; $i < sizeof ( $notifications ); $i ++) {
								if($type == 0 && !$notifications[$i]->isState()){
									array_splice ( $notifications, $i, 1 );
								}else if($type == 1 && !$notifications[$i]->isPwm()){
									array_splice ( $notifications, $i, 1 );
								}else if($type == 2 && !$notifications[$i]->isIsr()){
									array_splice ( $notifications, $i, 1 );
								}else if($type == 3 && !$notifications[$i]->isSerial()){
									array_splice ( $notifications, $i, 1 );
								}
							}
						}
						$gpio = HttpHelper::getVar ( self::$PARAM_GPIO );
						if (! is_bool ( $gpio )) {
							for($i = 0; $i < sizeof ( $notifications ); $i ++) {
								if ($notifications [$i]->gpio != $gpio) {
									array_splice ( $notifications, $i, 1 );
								}
							}
						}
						return self::response ( self::$CODE_OK, json_encode ( $notifications ) );
					}
				}
			}
		}
		logger::warning ( 'Bad request' );
		return self::response ();
	}
	/**
	 * Executed during POST
	 */
	static function executePost() {
		return self::response ( self::$CODE_NOT_IMPLEMENTED );
	}
	/**
	 * Executed during PUT
	 */
	static function executePut() {
		return self::response ( self::$CODE_NOT_IMPLEMENTED );
	}
	/**
	 * Executed during DELETE
	 */
	static function executeDelete() {
		return self::response ( self::$CODE_NOT_IMPLEMENTED );
	}
}