<?php
class ApiLogic extends Api {
	private static $PARAM_MODULE_ID = 'id';
	private static $PARAM_DESCRIPTION = 'description';
	private static $PARAM_CONDITIONS = 'conditions';
	private static $PARAM_ACTIONS_ID = 'actionsId';
	private static $PARAM_SCENARII_ID = 'scenariiId';
	/**
	 * Executed during GET
	 */
	static function executeGet() {
		$url = self::getCleanUrl ();
		if ($url === '') {
			$scenarii = DaoLogic::getScenarii ();
			return self::response ( self::$CODE_OK, json_encode ( $scenarii ) );
		} else if (is_numeric ( $url )) {
			$scenario = DaoLogic::getScenarioById ( $url );
			if ($scenario !== FALSE) {
				return self::response ( self::$CODE_OK, json_encode ( $scenario ) );
			}
		} else {
			logger::warning ( 'Bad request' );
		}
		return self::response ();
	}
	/**
	 * Executed during POST
	 */
	static function executePost() {
		$url = self::getCleanUrl ();
		$logicId = null;
		if (! empty ( $url )) {
			$logicId = $url;
		}
		$description = HttpHelper::postVar ( self::$PARAM_DESCRIPTION );
		$conditions = HttpHelper::postVar ( self::$PARAM_CONDITIONS );
		$actionsId = HttpHelper::postVar ( self::$PARAM_ACTIONS_ID );
		$scenariiId = HttpHelper::postVar ( self::$PARAM_SCENARII_ID );
		if (is_bool ( $description )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_DESCRIPTION );
			return self::response ();
		}
		if (is_bool ( $conditions )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_CONDITIONS );
			return self::response ();
		}
		if (is_bool ( $actionsId ) && is_bool ( $scenariiId )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_ACTIONS_ID . ' or ' . self::$PARAM_SCENARII_ID );
			return self::response ();
		}
		$scenario = new LogicScenario ( $description, $conditions, $actionsId, $scenariiId, $logicId );
		if (isset ( $logicId )) {
			$logicId = DaoLogic::modifyScenario ( $scenario );
		} else {
			$logicId = DaoLogic::addScenario ( $scenario );
		}
		if ($id === FALSE) {
			return self::response ();
		}
		return self::response ( self::$CODE_OK, '{ id : ' . $id . ' }' );
	}
	/**
	 * Executed during PUT
	 */
	static function executePut() {
		$url = self::getCleanUrl ();
		if (empty ( $url ) && $url !== '0') {
			Logger::warning ( 'Missing parameter' );
			return self::response ();
		}
		$scenarioId = self::getUrlParameter ( 0 );
		if ($senarioId !== FALSE) {
			$logicScenario = DaoLogic::getScenarioByid ( $scenarioId );
			if ($logicScenario !== FALSE) {
				if ($logicScenario->checkConditionsWithoutButtons()) {
					LogicManager::executeScenario ( $logicScenario );
					return self::response ( self::$CODE_OK, json_encode ( TRUE ) );
				}
				return self::response ( self::$CODE_OK, json_encode ( FALSE ) );
			}
		}
		return self::response ();
	}
	/**
	 * Executed during DELETE
	 */
	static function executeDelete() {
		$url = self::getCleanUrl ();
		if (is_bool ( $url )) {
			return self::response ();
		}
		if (is_numeric ( $url )) {
			$scenario = DaoLogic::delScenario ( $url );
			if ($scenario !== FALSE) {
				return self::response ( self::$CODE_OK );
			}
		}
		return self::response ();
	}
}