<?php
class ApiAction extends Api {
	private static $URL_MODULE = 'module';
	private static $PARAM_MODULE_ID = 'module_id';
	private static $PARAM_DESCRIPTION = 'description';
	private static $PARAM_GPIO = 'gpio';
	private static $PARAM_ACTION = 'action';
	private static $PARAM_VALUE = 'value';
	private static $PARAM_TYPE = 'type';
	/**
	 * Executed during GET
	 */
	static function executeGet() {
		$url = self::getCleanUrl ();
		if ($url === '') {
			$actions = DaoAction::getActions ();
			return self::response ( self::$CODE_OK, json_encode ( $actions ) );
		} else if (is_numeric ( $url )) {
			$action = DaoAction::getActionById ( $url );
			if ($action !== FALSE) {
				return self::response ( self::$CODE_OK, json_encode ( $action ) );
			}
		} else {
			$url = self::getUrlParameter ( 0 );
			if ($url === self::$URL_MODULE) {
				$id = self::getUrlParameter ( 1 );
				$actions = DaoAction::getActionsByModuleId ( $id );
				if ($actions !== FALSE) {
					return self::response ( self::$CODE_OK, json_encode ( $actions ) );
				}
			}
		}
		return self::response ();
	}
	/**
	 * Executed during POST
	 */
	static function executePost() {
		$url = self::getCleanUrl ();
		$actionId = null;
		if (! empty ( $url )) {
			$actionId = $url;
		}
		$moduleId = HttpHelper::postVar ( self::$PARAM_MODULE_ID );
		$description = HttpHelper::postVar ( self::$PARAM_DESCRIPTION );
		$action = HttpHelper::postVar ( self::$PARAM_ACTION );
		$gpio = HttpHelper::postVar ( self::$PARAM_GPIO );
		$value = HttpHelper::postVar ( self::$PARAM_VALUE );
		$type = HttpHelper::postVar ( self::$PARAM_TYPE );
		if (is_bool ( $moduleId )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_MODULE_ID );
			return self::response ();
		}
		if (is_bool ( $description )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_DESCRIPTION );
			return self::response ();
		}
		if (is_bool ( $action )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_ACTION );
			return self::response ();
		}
		if (is_bool ( $gpio )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_GPIO );
			return self::response ( self::$CODE_BAD_REQUEST, '{ error : "missing parameter ' . self::$PARAM_GPIO . '" }' );
		}
		if (is_bool ( $value )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_VALUE );
			return self::response ();
		} else if ($value < '0' && $value > sizeof ( Action::$ACTIONS_SENSORS ) - 1) {
			Logger::warning ( 'Wrong value for ' . self::$PARAM_VALUE . ' parameter' );
			return self::response ();
		}
		if (is_bool ( $type )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_TYPE );
			return self::response ();
		}
		$action = new Action ( $actionId, $moduleId, $description, $action, $gpio, $value, $type );
		if (isset ( $actionId )) {
			$actionId = DaoAction::modifyAction($action);
		} else {
			$actionId = DaoAction::addAction ( $action );
		}
		if ($actionId === FALSE) {
			return self::response ();
		}
		return self::response ( self::$CODE_OK, is_numeric($actionId) ? '{ id : ' . $actionId . ' }' : '' );
	}
	/**
	 * Executed during PUT
	 */
	static function executePut() {
		$url = self::getCleanUrl ();
		if (empty ( $url ) && $url !== '0') {
			Logger::warning ( 'Missing parameter' );
			return self::response ();
		}
		$actionId = self::getUrlParameter ( 0 );
		if ($actionId !== FALSE) {
			$action = DaoAction::getActionById ( $actionId );
			if ($action !== FALSE) {
				$result = ActionManager::getActionValue ( $action );
				if ($result !== FALSE) {
					return self::response ( self::$CODE_OK, $result );
				}
			}
		}
		return self::response ();
	}
	/**
	 * Executed during DELETE
	 */
	static function executeDelete() {
		$url = self::getCleanUrl ();
		if (is_bool ( $url )) {
			Logger::warning ( 'Missing parameter' );
			return self::response ();
		}
		if (is_numeric ( $url )) {
			$action = DaoAction::delAction ( $url );
			if ($action !== FALSE) {
				return self::response ( self::$CODE_OK );
			}
		}
		return self::response ();
	}
}