<?php

class MusicSender
{

    // L'adresse IP de l'enceinte connectée
    private $ip;

    // La socket utilisée pour communiquer avec l'enceinte
    private $socket;

    // Le port de l'enceinte connectée
    private static $PORT = 5045;

    // Le temps d'attente en microseconde entre chaque paquets
    private static $SLEEP_INTERVAL = 2500;

    // La taille de chacun des paquets
    private static $CHUNK_BUFFER = 32768;

    public function __construct($ip)
    {
        $this->ip = $ip;
    }

    /**
     * Envoie le MP3 à l'enceinte
     *
     * @param string $mp3File
     * @return boolean
     */
    public function play($mp3File)
    {
        if (is_file($mp3File)) {
            // Ouverture du fichier en lecture binaire
            $file = fopen($mp3File, 'rb');
            if ($file === FALSE) {
                echo "Fail reading file " . $file . "\n";
                return FALSE;
            }
            // Ouverture de la socket
            $socket = $this->openSocket();
            // Tant qu'on est pas à la fin du fichier
            while (! feof($file)) {
                // Envoie d'un "morceau" de taille CHUNK_BUFFER à l'enceinte
                if (@socket_write($this->socket, fread($file, self::$CHUNK_BUFFER), self::$CHUNK_BUFFER) === FALSE) {
                    // Problème de socket (fermeture, déconnexion, etc...)
                    return FALSE;
                }
                usleep(self::$SLEEP_INTERVAL);
            }
            // Fermeture de la socket
            $this->closeSocket();
            // Fermeture du fichier
            fclose($file);
            return TRUE;
        }
        echo $file." does not exists !\n";
        return FALSE;
    }

    /**
     * Lit tous les mp3 présents dans le dossier
     *
     * @param string $dir
     */
    public function readFolder($dir)
    {
        if (is_dir($dir)) {
            // On récupére les fichiers sans les 2 premiers '.' et '..'
            $files = array_slice(scandir($dir), 2);
            foreach ($files as $file) {
                // On créé le chemin absolu
                $mp3File = $dir . DIRECTORY_SEPARATOR . $file;
                // On test l'extension
                if (pathinfo($file)["extension"] == "mp3") {
                    $this->play($mp3File);
                }
            }
            return true;
        }
        return false;
    }

    /**
     * Ouverture de la socket
     */
    private function openSocket()
    {
        if (($this->socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP)) == FALSE) {
            echo "socket_create_listen() a échoué : " . socket_strerror(socket_last_error($this->socket)) . "\n";
            return false;
        }
        if (socket_connect($this->socket, $this->ip, self::$PORT) == FALSE) {
            echo "socket_bind() a échoué : " . socket_strerror(socket_last_error($this->socket)) . "\n";
            return false;
        }
    }

    /**
     * Fermeture de la socket
     */
    private function closeSocket()
    {
        socket_close($this->socket);
    }
}