#!/usr/bin/php
<?php
if (is_link ( __FILE__ )) {
	$dir = realpath ( __FILE__ );
	$dir = pathinfo ( $dir ) ['dirname'];
	include_once $dir . '/ScriptLauncher.class.php';
} else {
	include_once __DIR__ . '/ScriptLauncher.class.php';
}
class LaunchListener extends ScriptLauncher {
	public function start($argv) {
		$pids = MulticastListener::getPIDs ();
		if (empty ( $pids )) {
			echo 'Starting domotech-listener: ';
			new MulticastListener ();
			echo "done\n";
			exit ( 0 );
		}
		echo 'Process ' . MulticastListener::$PROCESS_NAME . " already running\n";
		exit ( 1 );
	}
	public function stop($argv, $isExit = TRUE) {
		if (! MulticastListener::stop ()) {
			echo 'Process ' . MulticastListener::$PROCESS_NAME . " is not running\n";
			if ($isExit) {
				exit ( 1 );
			}
		} else {
			echo 'Stopping process ' . MulticastListener::$PROCESS_NAME;
			while ( ! empty ( MulticastListener::getPIDs () ) ) {
				echo '.';
				sleep ( 1 );
			}
			echo "\n";
		}
	}
	public function status($argv) {
		$pids = MulticastListener::getPIDs ();
		if (empty ( $pids )) {
			echo MulticastListener::$PROCESS_NAME . ' is not running';
		} else {
			echo MulticastListener::$PROCESS_NAME . ' is running with PID(s): ';
			foreach ( $pids as $pid ) {
				echo $pid . ' ';
			}
		}
		echo "\n";
	}
	public function restart($argv) {
		self::stop ( $argv, false );
		self::start ( $argv );
	}
	public function help() {
		echo MulticastListener::$PROCESS_NAME . " usage :\n";
		echo "\t start   : to start the daemon\n";
		echo "\t stop    : to stop the daemon\n";
		echo "\t restart : to stop and start\n";
		echo "\t status  : to check the status and PID\n";
	}
}

LaunchListener::launch ( $argv, __FILE__, false );