<?php
abstract class ScriptLauncher {
	/**
	 * Call the scripts with the right execution context
	 *
	 * @param array $argv
	 *        	<br> the argv array containing the cli arguments
	 * @param string $file
	 *        	<br> the __FILE__ constant
	 */
	public static function launch($argv, $file, $isBackground) {
		self::setExecutionDir();
		include 'autoloader.php';
		if (sizeof ( $argv ) == 2) {
			if(!is_callable([ 'static', $argv[1] ])){
				return static::help ();
			}
			$toExec = 'static::'.$argv[1];
			call_user_func($toExec, $argv);
			exit(0);
		} 
		static::help ();
		exit(1);
	}
	/**
	 * Used to disaplay script usage
	 * 
	 * @param array $argv        	
	 */
	abstract public function help();
	/**
	 * Used to setup the correct execution directory
	 * @return boolean
	 */
	private static function setExecutionDir(){
		$dir = realpath(__FILE__);
		$dir = pathinfo($dir)['dirname'];
		if (! chdir ( $dir.'/../' )) {
			return FALSE;
		}
		return TRUE;
	}
}
?>