var URL_API = window.location.origin + '/' + window.location.pathname + '/api';
var URL_SCHEDULE = URL_API + '/schedule';
var URL_ACTIVATE = URL_SCHEDULE + '/activate';

var taskType = 0;

function showScheduleForm() {
	document.getElementById("schedule_button_span").innerHTML = "Add";
	document.getElementById('cron').value = '';
	document.getElementById('task_type').selectedIndex = 0;
	document.getElementById('task_action').selectedIndex = 0;
	document.getElementById('schedule_id').value = -1;
	document.getElementById('activateSchedule').checked = false;
	displayPage('addSchedule');
}

function displayTaskForm(type) {
	taskType = type;
	if (type == 0) {
		document.getElementById('div_actions').style.visibility = 'visible';
		document.getElementById('div_actions').style.height = '100%';
		document.getElementById('div_scenarii').style.visibility = 'collapse';
		document.getElementById('div_scenarii').style.height = '0px';
		document.getElementById('div_logic').style.visibility = 'collapse';
		document.getElementById('div_logic').style.height = '0px';
	} else if (type == 1) {
		document.getElementById('div_scenarii').style.visibility = 'visible';
		document.getElementById('div_scenarii').style.height = '100%';
		document.getElementById('div_actions').style.visibility = 'collapse';
		document.getElementById('div_actions').style.height = '0px';
		document.getElementById('div_logic').style.visibility = 'collapse';
		document.getElementById('div_logic').style.height = '0px';
	} else if (type == 2) {
		document.getElementById('div_actions').style.visibility = 'collapse';
		document.getElementById('div_actions').style.height = '0px';
		document.getElementById('div_scenarii').style.visibility = 'collapse';
		document.getElementById('div_scenarii').style.height = '0px';
		document.getElementById('div_logic').style.visibility = 'visible';
		document.getElementById('div_logic').style.height = '100%';
	}
}

function addSchedule() {
	var time = document.getElementById('cron').value;
	var taskId = '';
	if (taskType == 0) {
		taskId = document.getElementById('task_action').options[document
				.getElementById('task_action').selectedIndex].value;
	} else if (taskType == 1) {
		taskId = document.getElementById('task_scenario').options[document
				.getElementById('task_scenario').selectedIndex].value;
	} else if (taskType == 2) {
		taskId = document.getElementById('task_logic').options[document
				.getElementById('task_logic').selectedIndex].value;
	}
	var active = document.getElementById('activateSchedule').checked ? '1'
			: '0';
	var xhr = new XMLHttpRequest();
	var id = document.getElementById("schedule_id").value;
	if(id == -1){
		xhr.open('POST', URL_SCHEDULE, true);
	}else{
		xhr.open('POST', URL_SCHEDULE+'/'+id, true);
	}
	xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	xhr.onload = function() {
		if (xhr.status == 200) {
			location.replace("?page=schedule");
		} else {
			displayMessage('Creation failed !');
		}
	};
	var data = 'taskId=' + taskId + '&taskType=' + taskType + '&time=' + time
			+ '&active=' + active;
	xhr.send(data);
}

function modifySchedule(id){
	document.getElementById("schedule_button_span").innerHTML = "Modify";
	document.getElementById('schedule_id').value = id;
	var xhr = new XMLHttpRequest();
	xhr.open('GET', URL_SCHEDULE+'/'+id, true);
	xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	xhr.onload = function() {
		if (xhr.status == 200) {
			var response = JSON.parse(xhr.responseText);
			document.getElementById("cron").value = response.time;
			document.getElementById('activateSchedule').checked = response.active == 1;
			document.getElementById('task_type').selectedIndex = response.taskType;
			var selected = document.getElementById('task_action');
			if(response.taskType == 1){
				var selected = document.getElementById('task_scenario');
			}else if(response.taskType == 2){
				var selected = document.getElementById('task_logic');
			}
			for ( var i in selected) {
				if(selected[i].value == response.taskId){
					console.log(response.taskId);
					selected.selectedIndex = i;
					break;
				}
			}
			displayPage('addSchedule');
		}else{
			displayMessage('Fail getting schedule informations !');
		}
	}
	xhr.send();
}

function deleteSchedule(id) {
	if (!confirm("Voulez-vous supprimer cette programmation ?")) {
		return false;
	}
	var xhr = new XMLHttpRequest();
	xhr.open('DELETE', URL_SCHEDULE + '/' + id, true);
	xhr.onload = function() {
		if (xhr.status == 200) {
			location.replace("?page=schedule");
		} else {
			displayMessage('Delete failed !');
		}
	};
	xhr.send();
}

function activateSchedule(id) {
	var state = document.getElementById('activateSchedule' + id).checked ? '1'
			: '0';
	var xhr = new XMLHttpRequest();
	xhr.open('PUT', URL_ACTIVATE + '/' + id, true);
	xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	xhr.onload = function() {
		if (xhr.status == 200) {
			var message = state == '1' ? 'enable' : 'disable';
			message = 'Schedule sucessfuly ' + message;
			displayMessage(message);
		} else {
			var message = state == '1' ? 'enabling' : 'disabling';
			var message = 'Fail ' + message + ' schedule';
			state != state;
			displayMessage(message);
		}
	};
	xhr.send('active=' + state);
}

displayTaskForm(0);