var URL_API = window.location.origin + '/' + window.location.pathname + '/api';
var URL_SCENARIO = URL_API + '/scenario';

function displayScenario(id) {
	currentScenario = id;
	displayTitle(id);
	displayPage("scenario");
}

function showScenarioForm(){
	document.getElementById("scenario_description").value = '';
	var actions = document.getElementsByName("action_selector");
	for ( var index in actions) {
		actions[index].checked = false;
	}
	document.getElementById("scenario_id").value = -1;
	displayPage('scenario');
}

function displayScenarioContent(id) {
	for ( var index in scenarii) {
		if (scenarii[index] != id) {
			document.getElementById("actionsDiv" + scenarii[index]).style.visibility = 'collapse';
			document.getElementById("displayScenario" + scenarii[index]).src = "img/minimized.png";
		} else {
			if (document.getElementById("actionsDiv" + scenarii[index]).style.visibility == 'visible') {
				document.getElementById("actionsDiv" + scenarii[index]).style.visibility = 'collapse';
				document.getElementById("displayScenario" + scenarii[index]).src = "img/minimized.png";
			} else {
				document.getElementById("actionsDiv" + scenarii[index]).style.visibility = 'visible';
				document.getElementById("displayScenario" + scenarii[index]).src = "img/maximized.png";
			}
		}
	}
}

function executeScenario(id){
	var xhr = new XMLHttpRequest();
	xhr.open('PUT', URL_SCENARIO+'/'+id, true);
	xhr.onload = function() {
		if (xhr.status == 200) {
			displayMessage('Executing scenario...');
		} else {
			displayMessage('Execution failed !');
		}
	};
	xhr.send();
}

function addScenario(){
	var d = document.getElementById("scenario_description").value;
	var actions = document.getElementsByName("action_selector");
	var data = "description="+d;
	for ( var index in actions) {
		if(actions[index].checked){
			data += "&actions[]="+actions[index].value;
		}
	}
	var xhr = new XMLHttpRequest();
	var id = document.getElementById("scenario_id").value;
	if(id == -1){
		xhr.open('POST', URL_SCENARIO, true);
	}else{
		xhr.open('POST', URL_SCENARIO+'/'+id, true);
	}
	xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	xhr.onload = function() {
		if (xhr.status == 200) {
			location.replace("?page=scenarii");
		} else {
			displayMessage('Creation failed !');
		}
	};
	xhr.send(data);
}

function modifyScenario(id){
	document.getElementById("scenario_button_span").innerHTML = "Modify";
	var xhr = new XMLHttpRequest();
	xhr.open('GET', URL_SCENARIO+'/'+id, true);
	xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	xhr.onload = function() {
		if (xhr.status == 200) {
			var response = JSON.parse(xhr.responseText);
			document.getElementById("scenario_description").value = response.description;
			var actions = document.getElementsByName("action_selector");
			for ( var i in response.actionsId) {
				for( var j in actions){
					if(actions[j].value == response.actionsId[i]){
						actions[j].checked = true;
					}
				}
			}
			document.getElementById("scenario_id").value = id;
			displayPage("scenario");
		} else {
			displayMessage('Fail getting scenario informations');
		}
	};
	xhr.send();
}

function deleteScenario(id) {
	if (!confirm("Voulez-vous supprimer ce scenario ?")) {
		return false;
	}
	var xhr = new XMLHttpRequest();
	xhr.open('DELETE', URL_SCENARIO + '/' + id, true);
	xhr.onload = function() {
		if (xhr.status == 200) {
			location.replace("?page=scenarii");
		} else {
			displayMessage('Delete failed !');
		}
	};
	xhr.send();
}
displayScenarioContent(-1)