var URL_API = window.location.origin + '/' + window.location.pathname + '/api';
var URL_REMOTE = URL_API + '/remote';

function showRemoteForm() {
	document.getElementById('remote_button_span').innerHTML = 'Add';
	document.getElementById('remote_description').value = '';
	document.getElementById('nbButton').value = '';
	document.getElementById('serial').value = '';
	document.getElementById('idRemote').value = -1;
	displayPage('addRemote');
}

function addRemote() {
	var serial = document.getElementById('serial').value;
	var description = document.getElementById('remote_description').value;
	var nbButton = document.getElementById('nbButton').value;
	var id = document.getElementById('idRemote').value;
	var xhr = new XMLHttpRequest();
	if (id == -1) {
		xhr.open('POST', URL_REMOTE, true);
	} else {
		xhr.open('POST', URL_REMOTE + '/' + id, true);
	}
	xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	xhr.onload = function() {
		if (xhr.status == 200) {
			location.replace("?page=remotes");
		} else {
			displayMessage('Creation failed !');
		}
	};
	var data = 'serial=' + serial + '&description=' + description
			+ '&nbButton=' + nbButton;
	xhr.send(data);
}

function modifyRemote(id) {
	var xhr = new XMLHttpRequest();
	xhr.open('GET', URL_REMOTE + '/' + id, true);
	xhr.onload = function() {
		if (xhr.status == 200) {
			var remote = JSON.parse(xhr.responseText);
			document.getElementById('remote_description').value = remote.description;
			document.getElementById('nbButton').value = remote.nbButton;
			document.getElementById('serial').value = remote.serial;
			document.getElementById('idRemote').value = id;
			document.getElementById('remote_button_span').innerHTML = 'Modify';
			displayPage('addRemote');
		} else {
			displayMessage('Fail getting remote informations !');
		}
	};
	xhr.send();
}

function deleteRemote(id) {
	if (!confirm("Voulez-vous supprimer cette télécommande ?")) {
		return false;
	}
	var xhr = new XMLHttpRequest();
	xhr.open('DELETE', URL_REMOTE + '/' + id, true);
	xhr.onload = function() {
		if (xhr.status == 200) {
			location.replace("?page=remotes");
		} else {
			displayMessage('Delete failed !');
		}
	};
	xhr.send();
}