var URL_API = window.location.origin + '/' + window.location.pathname + '/api';
var URL_ACTION = URL_API + '/action';
var URL_MODULE = URL_API + '/module';
var URL_SCAN = URL_MODULE + '/scan';
var URL_CHECK = URL_MODULE + '/check';

function action(id) {
	var xhr = new XMLHttpRequest();
	xhr.open('PUT', URL_ACTION + '/' + id, true);
	xhr.onload = function() {
		var div = document.getElementById("actiondiv" + id);
		if (xhr.status == 200) {
			var response = JSON.parse(xhr.responseText);
			var state = response.state;
			var log = 'State changed to ';
			log += state == 0 ? 'off' : 'on';
			displayMessage(log);
			div.style.backgroundColor = "white";
		} else {
			displayMessage('Update failed !');
			div.style.backgroundColor = "red";
		}
	};
	xhr.send();
}

function displayActions(id) {
	for ( var index in modules) {
		if (modules[index] != id) {
			document.getElementById("actions" + modules[index]).style.visibility = 'collapse';
			document.getElementById("display" + modules[index]).src = "img/minimized.png";
		} else {
			if (document.getElementById("actions" + modules[index]).style.visibility == 'visible') {
				document.getElementById("actions" + modules[index]).style.visibility = 'collapse';
				document.getElementById("display" + modules[index]).src = "img/minimized.png";
			} else {
				document.getElementById("actions" + modules[index]).style.visibility = 'visible';
				document.getElementById("display" + modules[index]).src = "img/maximized.png";
			}
		}
	}
}

function displayAction(id) {
	currentModule = id;
	displayTitle(id);
	document.getElementById("action_description").value = '';
	document.getElementById("action").selectedIndex = 0;
	document.getElementById("type").selectedIndex = 0;
	document.getElementById("gpio").selectedIndex = 0;
	display();
	document.getElementById("action_span").innerHTML = "Ajouter";
	document.getElementById("action_button_span").innerHTML = "Ajouter";
	document.getElementById("action_id").value = -1;
	displayPage("action");
}

function modifyAction(moduleId, actionId) {
	fillActionForm(actionId);
	currentModule = moduleId;
	displayTitle(moduleId);
	document.getElementById("action_span").innerHTML = "Modifier";
	document.getElementById("action_button_span").innerHTML = "Modifier";
	document.getElementById("action_id").value = actionId;
	displayPage("action");
}

function deleteModule(id) {
	if (!confirm("Voulez-vous supprimer ce module ainsi que toutes les actions attachées ?")) {
		return false;
	}
	var xhr = new XMLHttpRequest();
	xhr.open('DELETE', URL_MODULE + '/' + id, true);
	xhr.onload = function() {
		if (xhr.status == 200) {
			location.replace("?page=modules");
		} else {
			displayMessage('Delete failed !');
		}
	};
	xhr.send();
}

function scan(add) {
	displayMessage("Scan en cours...");
	var xhr = new XMLHttpRequest();
	if (add) {
		xhr.open('POST', URL_SCAN, true);
	} else {
		xhr.open('GET', URL_SCAN, true);
	}
	xhr.onload = function() {
		if (xhr.status == 200) {
			var response = JSON.parse(xhr.responseText);
			var log;
			if (response.length == 0) {
				if (add) {
					log = "Aucun module ajouté";
				} else {
					log = "Aucun module disponible";
				}
			} else {
				if (add) {
					log = "Module(s)  ajouté(s): \n";
				} else {
					log = "Module(s)  disponible(s): \n";
				}
			}
			for ( var id in response) {
				log += "\t" + response[id].ip + " : " + response[id].hostname
						+ "\n";
			}
			alert(log);
			if (response.length != 0 && add) {
				location.replace("?page=modules");
			}
		} else {
			displayMessage('Update failed !');
		}
	};
	xhr.send();
}

function check() {
	var xhr = new XMLHttpRequest();
	xhr.open('POST', URL_CHECK, true);
	xhr.onload = function() {
		if (xhr.status == 200) {
			var result = JSON.parse(xhr.responseText);
			if (result.updated.length > 0) {
				location.replace("?page=modules");
			} else {
				displayMessage('No changes detected !');
			}
			if (result.unchanged.length > 0) {
				for (var i = 0; i < result.unchanged.length; i++) {
					var div = document
							.getElementById("mod" + result.unchanged[i]);
					div.style.backgroundColor = "white";
				}
			}
			if (result.missing.length > 0) {
				for (var i = 0; i < result.missing.length; i++) {
					var div = document
							.getElementById("mod" + result.missing[i]);
					div.style.backgroundColor = "red";
				}
			}
		} else {
			displayMessage('Check failed !');
		}
	};
	xhr.send();
}

function readTemp(id) {
	displayMessage("Lecture des températures en cours...");
	var xhr = new XMLHttpRequest();
	xhr.open('PUT', URL_ACTION + '/' + id, true);
	xhr.onload = function() {
		var div = document.getElementById("actiondiv" + id);
		if (xhr.status == 200) {
			var response = JSON.parse(xhr.responseText);
			if(response == false){
				displayMessage('Reading failed !');
				document.getElementById(id).innerHTML = 'NaN';
				div.style.backgroundColor = "red";
			}else{
				document.getElementById(id).innerHTML = response;
				div.style.backgroundColor = "white";
			}
		} else {
			displayMessage('Reading failed !');
			document.getElementById(id).innerHTML = 'NaN';
			div.style.backgroundColor = "red";
		}
	};
	xhr.send();
}

function readState(id) {
	displayMessage("Lecture des états en cours...");
	var xhr = new XMLHttpRequest();
	xhr.open('PUT', URL_ACTION + '/' + id, true);
	xhr.onload = function() {
		var div = document.getElementById("actiondiv" + id);
		if (xhr.status == 200) {
			var response = JSON.parse(xhr.responseText);
			if (response.state == '1') {
				document.getElementById(id).src = 'img/on.png';
			} else {
				document.getElementById(id).src = 'img/off.png';
			}
			div.style.backgroundColor = "white";
		} else {
			displayMessage('Reading failed !');
			div.style.backgroundColor = "red";
		}
	};
	xhr.send();
}

function deleteAction(id) {
	if (!confirm("Voulez-vous supprimer cette action ?")) {
		return false;
	}
	var xhr = new XMLHttpRequest();
	xhr.open('DELETE', URL_ACTION + '/' + id, true);
	xhr.onload = function() {
		if (xhr.status == 200) {
			location.replace("?page=modules");
		} else {
			displayMessage("Effacement echoué !");
		}
	};
	xhr.send();
}

function addAction(id) {
	openPopup(window.location.origin + '/' + window.location.pathname
			+ '/action?id=' + id, 300, 500);
}

function modifyModule(id) {
	openPopup(window.location.origin + '/' + window.location.pathname
			+ '/module?id=' + id, 500, 800);
}

function actualize(sensor, type) {
	for ( var id in sensor) {
		if (type == 'temp') {
			readTemp(sensor[id][0], sensor[id][1]);
		} else if (type == 'state') {
			readState(sensor[id]);
		}
	}
}

actualize(sensorTemps, 'temp');
actualize(sensorStates, 'state');
setInterval(actualize, SENSOR_REFRESH, sensorTemps, 'temp');
setInterval(actualize, STATE_REFRESH, sensorStates, 'state');
displayActions(-1);
