<?php
class ViewSchedule extends View {
	private static $PARAM_TASK_TYPE = '__TASK_TYPE__';
	private static $PARAM_ACTIVE = '__ACTIVE__';
	private static $PARAM_DESCRIPTION = '__DESCRIPTION__';
	private static $PARAM_TIME = '__TIME__';
	private static $PARAM_MODIFY_BUTTON = '__MODIFY_BUTTON__';
	private static $PARAM_DEL_BUTTON = '__DEL_BUTTON__';
	
	/**
	 * Display the javascript for sensors
	 */
	public static function displaySchedules() {
		$schedules = DaoSchedule::getSchedules ();
		$html = '';
		foreach ( $schedules as $schedule ) {
			$time = $schedule->time;
			$description = '';
			$image = '';
			if ($schedule->taskType == Schedule::TASK_TYPE_ACTION) {
				$action = DaoAction::getActionById ( $schedule->taskId );
				$description = $action->description;
				if ($action->action == Action::$ACTION_STATE) {
					$image .= self::includeImage ( 'state', 'icon', 'onClick="action(\'' . $action->id . '\')"' );
				} else if ($action->action == Action::$ACTION_TOGGLE) {
					$image .= self::includeImage ( 'toggle', 'icon', 'onClick="action(\'' . $action->id . '\')"' );
				} else if ($action->action == Action::$ACTION_TIMED) {
					$image .= self::includeImage ( 'timer', 'icon', 'onClick="action(\'' . $action->id . '\')"' );
				} else if ($action->action == Action::$ACTION_PWM) {
					$image .= self::includeImage ( 'pwm', 'icon', 'onClick="action(\'' . $action->id . '\')"' );
				}
			} else if ($schedule->taskType == Schedule::TASK_TYPE_SCENARIO) {
				$scenario = DaoScenario::getScenarioByid ( $schedule->taskId );
				$description = $scenario->description;
				$image = self::includeImage ( 'execute', 'icon', 'onClick="executeScenario(\'' . $scenario->id . '\')"' );
			}else if ($schedule->taskType == Schedule::TASK_TYPE_LOGIC) {
				$scenario = DaoLogic::getScenarioByid ( $schedule->taskId );
				$description = $scenario->description;
				$image = self::includeImage ( 'execute', 'icon', 'onClick="executeLogic(\'' . $scenario->id . '\')"' );
			}
			$html .= self::processTemplate ( 'schedule', [ 
					self::$PARAM_ID,
					self::$PARAM_ACTIVE,
					self::$PARAM_TASK_TYPE,
					self::$PARAM_DESCRIPTION,
					self::$PARAM_TIME,
					self::$PARAM_MODIFY_BUTTON,
					self::$PARAM_DEL_BUTTON 
			], [ 
					$schedule->id,
					$schedule->active ? 'checked' : '',
					$image,
					$description,
					$time,
					self::includeImage ( 'modify', 'icon', 'onClick="modifySchedule(\'' . $schedule->id . '\')"' ),
					self::includeImage ( 'delete', 'icon', 'onClick="deleteSchedule(\'' . $schedule->id . '\')"' ) 
			] );
		}
		return $html;
	}
	public static function displayActionTaskList() {
		$html = '<select id="task_action">';
		$actions = DaoAction::getActions ();
		foreach ( $actions as $action ) {
			if ($action->action != 4) {
				$html .= '<option value="' . $action->id . '">' . $action->description . '</option>';
			}
		}
		$html .= '</select>';
		return $html;
	}
	public static function displayScenarioTaskList() {
		$html = '<select id="task_scenario">';
		$scenarii = DaoScenario::getScenarii ();
		foreach ( $scenarii as $scenario ) {
			$html .= '<option value="' . $scenario->id . '">' . $scenario->description . '</option>';
		}
		$html .= '</select>';
		return $html;
	}
	public static function displayLogicTaskList() {
		$html = '<select id="task_logic">';
		$scenarii = DaoLogic::getScenarii ();
		foreach ( $scenarii as $scenario ) {
			$html .= '<option value="' . $scenario->id . '">' . $scenario->description . '</option>';
		}
		$html .= '</select>';
		return $html;
	}
}