<?php
class ViewScenarioLogic extends View {
	private static $PARAM_NAME = '__NAME__';
	private static $PARAM_DISPLAY = '__DISPLAY__';
	private static $PARAM_DESCRIPTION = '__DESCRIPTION__';
	private static $PARAM_CHECK_BUTTON = '__CHECK_BUTTON__';
	private static $PARAM_MODIFY_BUTTON = '__MODIFY_BUTTON__';
	private static $PARAM_DEL_BUTTON = '__DEL_BUTTON__';
	private static $PARAM_CONDITIONS = '__CONDITIONS__';
	private static $PARAM_ACTIONS = '__ACTIONS__';
	private static $PARAM_SCENARII = '__SCENARII__';
	
	/**
	 * Display the javascript for sensors
	 */
	public static function displayScenarii() {
		$scenarii = DaoLogic::getScenarii ();
		$html = '';
		if($scenarii === FALSE){
			return '';
		}
		foreach ( $scenarii as $scenario ) {
			$conditionHtml = '';
			foreach ( $scenario->conditions as $condition ) {
				$conditionHtml .= ViewAction::displaySensorFromEvent ( $condition );
			}
			$actionHtml = '';
			if (! empty ( $scenario->actionsId)) {
				foreach ( $scenario->actionsId as $actionId ) {
					$action = DaoAction::getActionById ( $actionId );
					$module = DaoModule::getModuleById ( $action->moduleId );
					if ($module == FALSE) {
						continue;
					}
					$actionHtml .= ViewModule::displayModuleListForScenarii ( $module, $action );
				}
			} else {
				$actionHtml = 'None';
			}
			$scenarioHtml = '';
			$logicScenarii = [ ];
			if (! empty ( $scenario->scenariiId )) {
				foreach ( $scenario->scenariiId as $scenarioId ) {
					$logicScenarii [] = DaoScenario::getScenarioByid ( $scenarioId );
				}
				$scenarioHtml .= ViewScenario::displayScenariiForLogic ( $logicScenarii, false );
			} else {
				$scenarioHtml = 'None';
			}
			$html .= self::processTemplate ( 'logic', [ 
					self::$PARAM_ID,
					self::$PARAM_DISPLAY,
					self::$PARAM_CHECK_BUTTON,
					self::$PARAM_DESCRIPTION,
					self::$PARAM_MODIFY_BUTTON,
					self::$PARAM_DEL_BUTTON,
					self::$PARAM_CONDITIONS,
					self::$PARAM_ACTIONS,
					self::$PARAM_SCENARII 
			], [ 
					$scenario->id,
					self::includeImage ( 'minimized', 'icon', 'onClick="displayLogicContent(\'' . $scenario->id . '\')"', 'displayLogic' . $scenario->id ),
					self::includeImage ( 'execute', 'icon', 'onClick="executeLogic(\'' . $scenario->id . '\')"' ),
					$scenario->description,
					self::includeImage ( 'modify', 'icon', 'onClick="modifyLogic(\'' . $scenario->id . '\')"' ),
					self::includeImage ( 'delete', 'icon', 'onClick="deleteLogic(\'' . $scenario->id . '\')"' ),
					$conditionHtml,
					$actionHtml,
					$scenarioHtml 
			] );
		}
		return $html;
	}
	/**
	 * Displays the necessary for Javascript
	 */
	public static function displayIds() {
		$scenarii = DaoLogic::getScenarii ();
		echo 'var logicScenarii = [ ';
		for($i = 0; $i < sizeof ( $scenarii ); $i ++) {
			echo $scenarii [$i]->id;
			if ($i != sizeof ( $scenarii ) - 1) {
				echo ', ';
			}
		}
		echo ' ];';
	}
}