<?php
class ViewRemote extends View {
	private static $PARAM_IMG = '__IMG__';
	private static $PARAM_NB_BUTTONS = '__NB_BUTTONS__';
	private static $PARAM_SERIAL = '__SERIAL__';
	private static $PARAM_DESCRIPTION = '__DESCRIPTION__';
	private static $PARAM_MODIFY_BUTTON = '__MODIFY_BUTTON__';
	private static $PARAM_DELETE_BUTTON = '__DELETE_BUTTON__';
	
	/**
	 * Produce the HTML used to display remotes
	 *
	 * @param int $id
	 *        	<br> the module id
	 * @return string
	 */
	public static function displayRemoteList() {
		$remoteHtml = '';
		$remotes = DaoRemote::getRemotes ();
		foreach ( $remotes as $remote ) {
			$remoteHtml .= self::processTemplate ( 'remote', [ 
					self::$PARAM_ID,
					self::$PARAM_IMG,
					self::$PARAM_NB_BUTTONS,
					self::$PARAM_SERIAL,
					self::$PARAM_DESCRIPTION,
					self::$PARAM_MODIFY_BUTTON,
					self::$PARAM_DELETE_BUTTON 
			], [ 
					$remote->id,
					self::includeImage ( 'remote' ),
					'boutons<br>'.$remote->nbButton,
					'serial<br>'.$remote->serial,
					$remote->description,
					self::includeImage ( 'modify', 'icon', 'onClick="modifyRemote(\'' . $remote->id . '\')"' ),
					self::includeImage ( 'delete', 'icon', 'onClick="deleteRemote(\'' . $remote->id . '\')"' ) 
			] );
		}
		return $remoteHtml;
	}
	/**
	 * Produce the HTML used to display remotes for logic purpose
	 *
	 * @param int $id
	 *        	<br> the module id
	 * @return string
	 */
	public static function displayRemotesForLogic() {
		$remoteHtml = '';
		$remotes = DaoRemote::getRemotes ();
		foreach ( $remotes as $remote ) {
			$conditions = '<select id="logicRemoteCondition' . $remote->id . '">';
			$values = '<input type="number" id="logicRemoteValue' . $remote->id . '" value="1" min="1" max="'.$remote->nbButton.'">';
			$conditions = '=<br>';
			$forms = $conditions . $values;
			$checkBoxHtml = 'Add<br><input type="checkbox" value="' . $remote->id . '" name="remotes_selector">';
			$remoteHtml .= self::processTemplate ( 'remote', [ 
					self::$PARAM_ID,
					self::$PARAM_IMG,
					self::$PARAM_NB_BUTTONS,
					self::$PARAM_SERIAL,
					self::$PARAM_DESCRIPTION,
					self::$PARAM_MODIFY_BUTTON,
					self::$PARAM_DELETE_BUTTON 
			], [ 
					$remote->id,
					self::includeImage ( 'remote' ),
					$forms,
					'',
					$remote->description,
					'',
					$checkBoxHtml 
			] );
		}
		return $remoteHtml;
	}
}