<?php
abstract class LogicEvent {
	const CONDITIONS = [ 
			'=',
			'!=',
			'>',
			'<',
			'>=',
			'<=' 
	];
	const CONDITION_EQUAL = 0;
	const CONDITION_NOT_EQUAL = 1;
	const CONDITION_SUPERIOR = 2;
	const CONDITION_INFERIOR = 3;
	const CONDITION_SUPERIOR_EQUAL = 4;
	const CONDITION_INFERIOR_EQUAL = 5;
	public $id;
	public $actionId;
	public $condition;
	public $value;
	public function __construct($id, $actionId, $condition, $value) {
		$this->id = $id;
		$this->actionId = $actionId;
		$this->condition = $condition;
		$this->value = $value;
	}
	/**
	 * Return TRUE if Event is TRUE
	 *
	 * @return boolean
	 */
	public function checkCondition($value = null) {
		if (is_a ( $this, 'LogicEventButton' ) && !isset($value)) {
			return FALSE;
		}
		if (! isset ( $value ) && ! RemoteModule::isRemote ( $this->actionId )) {
			$action = DaoAction::getActionById ( $this->actionId );
			$value = ActionManager::getActionValue ( $action, false );
		}
		if ($this->condition == self::CONDITION_EQUAL) {
			return $value == $this->value;
		} else if ($this->condition == self::CONDITION_NOT_EQUAL) {
			return $value != $this->value;
		} else if ($this->condition == self::CONDITION_SUPERIOR) {
			return intval ( $value ) > intval ( $this->value );
		} else if ($this->condition == self::CONDITION_INFERIOR) {
			return intval ( $value ) < intval ( $this->value );
		} else if ($this->condition == self::CONDITION_SUPERIOR_EQUAL) {
			return intval ( $value ) >= intval ( $this->value );
		} else if ($this->condition == self::CONDITION_INFERIOR_EQUAL) {
			return intval ( $value ) <= intval ( $this->value );
		}
		return FALSE;
	}
	public function getConditionStrings() {
		$cdt = [ ];
		foreach ( static::CONDITIONS as $index ) {
			$cdt [] = self::CONDITIONS [$index];
		}
		return $cdt;
	}
	/**
	 * Return the LogicEvent object from a string or FALSE
	 *
	 * eg. 17:1:0 means :
	 * <ul>
	 * <li>action id 17</li>
	 * <li>condition 0 (!=)</li>
	 * <li>value 0</li>
	 * </ul>
	 *
	 * @param string $string        	
	 * @return boolean|LogicEventTemp|LogicEventState|LogicEventButton
	 */
	public static function getLogicEventFromString($string) {
		if (strpos ( $string, ':' ) === FALSE) {
			Logger::warning ( 'String is not correct [ ' . $string . ' ]' );
			return FALSE;
		}
		$parts = explode ( ':', $string );
		if (sizeof ( $parts ) !== 3) {
			Logger::warning ( 'String is not correct [ ' . $string . ' ]' );
			return FALSE;
		}
		$actionId = $parts [0];
		$condition = $parts [1];
		$value = $parts [2];
		if (substr ( $actionId, 0, 1 ) === RemoteModule::REMOTE_PREFIX) {
			$remote = DaoRemote::getRemoteById ( $actionId );
			if ($remote === FALSE) {
				return FALSE;
			}
			return new LogicEventRemote ( 0, $remote->id, $condition, $value );
		} else {
			$action = DaoAction::getActionById ( $actionId );
			if ($action === FALSE) {
				return FALSE;
			}
			if (! $action->isSensor ()) {
				Logger::warning ( 'Condition must be a sensor !' );
				return FALSE;
			}
			if ($action->getSensorType () == Action::$SENSOR_TEMP) {
				return new LogicEventTemp ( 0, $actionId, $condition, $value );
			} else if ($action->getSensorType () == Action::$SENSOR_STATE) {
				return new LogicEventState ( 0, $actionId, $condition, $value );
			} else if ($action->getSensorType () == Action::$SENSOR_BUTTON) {
				return new LogicEventButton ( 0, $actionId, $condition, $value );
			}
		}
		Logger::warning ( 'Unknown sensor type [ ' . $action->getSensorType () . ' ]' );
		return FALSE;
	}
}