<?php
/**
 *
 * @author Tala
 *
 */
class HttpHelper {
	const URL_VAR = "url";
	/**
	 * Return the requested URL
	 *
	 * @return boolean|string
	 */
	public static function getUrl() {
		return self::getVar ( self::URL_VAR );
	}
	/**
	 * Return the base URL where the application is
	 *
	 * @return string
	 */
	public static function getBaseUrl() {
		$url = self::getUrl ();
		$requestUri = $_SERVER ['REQUEST_URI'];
		return trim ( substr ( $requestUri, 0, strlen ( $requestUri ) - strlen ( $url ) ), '/' );
	}
	/**
	 * Send a GET request with a timeout of 5 seconds
	 * 
	 * @param string $url
	 *        	<br> The full url eg. http://host/resource
	 * @param int $http_code
	 *        	<br> Used to set the http code
	 * @return string|boolean <br> the content of the request of false
	 */
	public static function sendHttpRequest($url, &$http_code = null, $verb='GET') {
		$ch = curl_init ();
		Logger::debug ( 'Sending http request [ ' . $url. ' ]' );
		curl_setopt ( $ch, CURLOPT_URL, $url);
		curl_setopt ( $ch, CURLOPT_CONNECTTIMEOUT, 5 );
		curl_setopt ( $ch, CURLOPT_TIMEOUT, 5 );
		curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, 1 );
		if($verb !== 'GET'){
			curl_setopt ( $ch, CURLOPT_CUSTOMREQUEST, $verb);
		}
		$output = curl_exec ( $ch );
		if (isset ( $http_code )) {
			$http_code = curl_getinfo ( $ch );
			$http_code = $http_code['http_code'];
		}
		curl_close ( $ch );
		return $output;
	}
	/**
	 * Return parameters sent in SERVER
	 *
	 * @param string $name
	 *        	<br> The name of the parameter
	 * @return boolean|string <ul>
	 *         <li>false if the parameter doesn't exists</li>
	 *         <li>true if the parameter exists but is empty</li>
	 *         <li>string the parameter value</li>
	 *         </ul>
	 */
	public static function serverVar($name) {
		return self::retrieveVar ( $name, $_SERVER );
	}
	/**
	 * Return parameters sent in SESSION
	 *
	 * @param string $name
	 *        	<br> The name of the parameter
	 * @return boolean|string <ul>
	 *         <li>false if the parameter doesn't exists</li>
	 *         <li>true if the parameter exists but is empty</li>
	 *         <li>string the parameter value</li>
	 *         </ul>
	 */
	public static function sessionVar($name) {
		return self::retrieveVar ( $name, $_SESSION );
	}
	/**
	 * Return parameters sent in GET
	 *
	 * @param string $name
	 *        	<br> The name of the parameter
	 * @return boolean|string <ul>
	 *         <li>false if the parameter doesn't exists</li>
	 *         <li>true if the parameter exists but is empty</li>
	 *         <li>string the parameter value</li>
	 *         </ul>
	 */
	public static function getVar($name) {
		if (! isset ( $_GET )) {
			return FALSE;
		}
		return self::retrieveVar ( $name, $_GET );
	}
	/**
	 * Return parameters sent in POST
	 *
	 * @param string $name
	 *        	<br> The name of the parameter
	 * @return boolean|string <ul>
	 *         <li>false if the parameter doesn't exists</li>
	 *         <li>true if the parameter exists but is empty</li>
	 *         <li>string the parameter value</li>
	 *         </ul>
	 */
	public static function postVar($name) {
		if (! isset ( $_POST )) {
			return FALSE;
		}
		return self::retrieveVar ( $name, $_POST );
	}
	/**
	 * Return parameters sent in PUT
	 *
	 * @param string $name
	 *        	<br> The name of the parameter
	 * @return boolean|string <ul>
	 *         <li>false if the parameter doesn't exists</li>
	 *         <li>true if the parameter exists but is empty</li>
	 *         <li>string the parameter value</li>
	 *         </ul>
	 */
	public static function putVar($name) {
		$values = array ();
		parse_str ( self::putContent (), $values );
		return self::retrieveVar ( $name, $values );
	}
	/**
	 * Return parameters sent in DELETE
	 *
	 * @param string $name
	 *        	<br> The name of the parameter
	 * @return boolean|string <ul>
	 *         <li>false if the parameter doesn't exists</li>
	 *         <li>true if the parameter exists but is empty</li>
	 *         <li>string the parameter value</li>
	 *         </ul>
	 */
	public static function deleteVar($name) {
		return self::putVar ( $name );
	}
	/**
	 * Return the "php://input" content
	 *
	 * @return string
	 */
	public static function putContent() {
		return file_get_contents ( "php://input" );
	}
	/**
	 * Return parameters present in array
	 *
	 * @param string $name
	 *        	<br> The name of the parameter
	 * @param array $tab
	 *        	<br> The array containing the parameter
	 * @return boolean|string <ul>
	 *         <li>false if the parameter doesn't exists</li>
	 *         <li>true if the parameter exists but is empty</li>
	 *         <li>string the parameter value</li>
	 *         </ul>
	 */
	private static function retrieveVar($name, $tab) {
		if (isset ( $tab [$name] )) {
			if (! empty ( $tab [$name] ) || $tab [$name] == 0) {
				return $tab [$name];
			}
			return TRUE;
		}
		return FALSE;
	}
}