<?php
class DaoRemote extends Dao {
	protected static $DB_FILE = 'remote.db';
	private static $INDEX_ID = 0;
	private static $INDEX_SERIAL = 1;
	private static $INDEX_DESCRIPTION = 2;
	private static $INDEX_NB_BUTTON = 3;
	/**
	 * Return all remotes in db
	 *
	 * @return RemoteModule[]
	 */
	public static function getRemotes() {
		$dbRemotes = self::getValues ();
		if (empty ( $dbRemotes )) {
			return [ ];
		}
		$remotes = [ ];
		foreach ( $dbRemotes as $dbRemote ) {
			$remotes [] = new RemoteModule ( $dbRemote [self::$INDEX_SERIAL], $dbRemote [self::$INDEX_DESCRIPTION], $dbRemote [self::$INDEX_NB_BUTTON], $dbRemote [self::$INDEX_ID] );
		}
		return $remotes;
	}
	/**
	 * Return the remote corresponding to the given id
	 *
	 * @param int $id
	 *        	<br> The remote id
	 * @return RemoteModule|boolean <br>The remote object or false
	 */
	public static function getRemoteById($id) {
		$dbRemotes = self::getValues ();
		if (! empty ( $dbRemotes )) {
			foreach ( $dbRemotes as $dbRemote ) {
				if ($dbRemote [self::$INDEX_ID] == $id) {
					return new RemoteModule ( $dbRemote [self::$INDEX_SERIAL], $dbRemote [self::$INDEX_DESCRIPTION], $dbRemote [self::$INDEX_NB_BUTTON], $dbRemote [self::$INDEX_ID] );
				}
			}
		}
		Logger::info ( 'Remote with id ' . $id . ' does not exists' );
		return FALSE;
	}
	/**
	 * Return the remote corresponding to the given serial
	 *
	 * @param int $id
	 *        	<br> The remote id
	 * @return RemoteModule|boolean <br>The remote object or false
	 */
	public static function getRemoteBySerial($serial) {
		$dbRemotes = self::getValues ();
		if (! empty ( $dbRemotes )) {
			foreach ( $dbRemotes as $dbRemote ) {
				if ($dbRemote [self::$INDEX_SERIAL] == $serial) {
					return new RemoteModule ( $dbRemote [self::$INDEX_SERIAL], $dbRemote [self::$INDEX_DESCRIPTION], $dbRemote [self::$INDEX_NB_BUTTON], $dbRemote [self::$INDEX_ID] );
				}
			}
		}
		Logger::info ( 'Remote with serial ' . $serial . ' does not exists' );
		return FALSE;
	}
	/**
	 * Add the remote to the db if not already in
	 *
	 * @param RemoteModule $remote        	
	 * @return boolean
	 */
	public static function addRemote(RemoteModule $remote) {
		$m = self::getRemoteBySerial( $remote->serial );
		if ($m === FALSE) {
			$dbRemotes = self::getValues ();
			$id = 'R'.self::getNextId ();
			$dbRemotes [] = [ 
					self::$INDEX_ID => $id,
					self::$INDEX_DESCRIPTION => $remote->description,
					self::$INDEX_SERIAL => $remote->serial,
					self::$INDEX_NB_BUTTON => $remote->nbButton 
			];
			self::write ( $dbRemotes );
			Logger::info ( 'Adding remote with id ' . $id . ' in db' );
			return $id;
		}
		Logger::info ( 'Remote ' . $remote->serial . ' already in db' );
		return $m->id;
	}
	/**
	 * Modify the remote
	 *
	 * @param RemoteModule $remote
	 * @return boolean
	 */
	public static function modifyRemote(RemoteModule $remote) {
		$dbRemotes = self::getValues ();
		for ($i = 0; $i < sizeof($dbRemotes); $i++) {
			if($dbRemotes[$i][self::$INDEX_ID] == $remote->id){
				$dbRemotes [$i][self::$INDEX_DESCRIPTION] = $remote->description;
				$dbRemotes [$i][self::$INDEX_SERIAL] = $remote->serial;
				$dbRemotes [$i][self::$INDEX_NB_BUTTON] = $remote->nbButton;
				self::write ( $dbRemotes );
				Logger::info ( 'Modifying remote with id ' . $id . ' in db' );
				return $id;
			}
		}
		Logger::info ( 'Remote ' . $remote->id . ' not in db' );
		return FALSE;
	}
	/**
	 * Delete an existing remote
	 *
	 * @param int $id        	
	 * @return boolean
	 */
	public static function delRemote($id) {
		$dbRemotes = self::getValues ();
		if (empty ( $dbRemotes )) {
			return FALSE;
		}
		for($i = 0; $i < sizeof ( $dbRemotes ); $i ++) {
			if ($dbRemotes [$i] [self::$INDEX_ID] == $id) {
				array_splice ( $dbRemotes, $i, 1 );
				self::write ( $dbRemotes );
				Logger::info ( "Deleting remote with id " . $id );
				return TRUE;
			}
		}
		Logger::info ( 'Remote ' . $id . ' does not exists in db' );
		return FALSE;
	}
}