<?php
class DaoLogic extends Dao {
	protected static $DB_FILE = 'logicScenarii.db';
	private static $INDEX_ID = 0;
	private static $INDEX_DESCRIPTION = 1;
	private static $INDEX_CONDITIONS = 2;
	private static $INDEX_ACTIONS_ID = 3;
	private static $INDEX_SCENARII_ID = 4;
	/**
	 * Return all scnearii in db
	 *
	 * @return Scneario[]
	 */
	public static function getScenarii() {
		$dbLogicScenarii = self::getValues ();
		if (empty ( $dbLogicScenarii )) {
			return [ ];
		}
		$logicScenarii = [ ];
		foreach ( $dbLogicScenarii as $dbLogicScenario ) {
			$conditions = self::getConditionObjectsFromStrings ( $dbLogicScenario [self::$INDEX_CONDITIONS] );
			if ($conditions == FALSE) {
				continue;
			}
			$logicScenarii [] = new LogicScenario ( $dbLogicScenario [self::$INDEX_DESCRIPTION], $conditions, $dbLogicScenario [self::$INDEX_ACTIONS_ID], $dbLogicScenario [self::$INDEX_SCENARII_ID], $dbLogicScenario [self::$INDEX_ID] );
		}
		return $logicScenarii;
	}
	/**
	 * Return the logicScenario corresponding to the given ID
	 *
	 * @param string $id
	 *        	<br> The logicScenario id
	 * @return LogicScenario|boolean <br>The logicScenario object or false
	 */
	public static function getScenarioByid($id) {
		$dbLogicScenarii = self::getValues ();
		if (! empty ( $dbLogicScenarii )) {
			foreach ( $dbLogicScenarii as $dbLogicScenario ) {
				if ($dbLogicScenario [self::$INDEX_ID] == $id) {
					$conditions = self::getConditionObjectsFromStrings ( $dbLogicScenario [self::$INDEX_CONDITIONS] );
					if ($conditions === FALSE) {
						return FALSE;
					}
					return new LogicScenario ( $dbLogicScenario [self::$INDEX_DESCRIPTION], $conditions, $dbLogicScenario [self::$INDEX_ACTIONS_ID], $dbLogicScenario [self::$INDEX_SCENARII_ID], $dbLogicScenario [self::$INDEX_ID] );
				}
			}
		}
		Logger::warning ( 'LogicScenario with id ' . $id . ' does not exists' );
		return FALSE;
	}
	/**
	 * Return all scnearii in db
	 *
	 * @return Scneario[]
	 */
	public static function getScenariiContainingConditions($actionId) {
		$dbLogicScenarii = self::getValues ();
		if (empty ( $dbLogicScenarii )) {
			return [ ];
		}
		$logicScenarii = [ ];
		foreach ( $dbLogicScenarii as $dbLogicScenario ) {
			$conditions = self::getConditionObjectsFromStrings ( $dbLogicScenario [self::$INDEX_CONDITIONS] );
			if ($conditions !== FALSE) {
				foreach ( $conditions as $condition ) {
					if ($condition->actionId == $actionId) {
						$logicScenarii [] = new LogicScenario ( $dbLogicScenario [self::$INDEX_DESCRIPTION], $conditions, $dbLogicScenario [self::$INDEX_ACTIONS_ID], $dbLogicScenario [self::$INDEX_SCENARII_ID], $dbLogicScenario [self::$INDEX_ID] );
						break;
					}
				}
			}
		}
		return $logicScenarii;
	}
	/**
	 * Add the logicScenario to the db
	 *
	 * @param LogicScenario $logicScenario        	
	 * @return boolean
	 */
	public static function addScenario(LogicScenario $logicScenario) {
		$dbLogicScenarii = self::getValues ();
		foreach ( $logicScenario->conditions as $condition ) {
			if (LogicEvent::getLogicEventFromString ( $condition ) == FALSE) {
				return FALSE;
			}
		}
		foreach ( $logicScenario->actionsId as $action_id ) {
			if (DaoAction::getActionById ( $action_id ) === FALSE) {
				return FALSE;
			}
		}
		foreach ( $logicScenario->scenariiId as $logicScenario_id ) {
			if (DaoScenario::getScenarioByid ( $logicScenario_id ) === FALSE) {
				return FALSE;
			}
		}
		$id = self::getNextId ();
		$dbLogicScenarii [] = [ 
				self::$INDEX_ID => $id,
				self::$INDEX_DESCRIPTION => $logicScenario->description,
				self::$INDEX_CONDITIONS => $logicScenario->conditions,
				self::$INDEX_ACTIONS_ID => $logicScenario->actionsId,
				self::$INDEX_SCENARII_ID => $logicScenario->scenariiId 
		];
		self::write ( $dbLogicScenarii );
		return $id;
	}
	/**
	 * Modify the logicScenario
	 *
	 * @param LogicScenario $logicScenario
	 * @return boolean
	 */
	public static function modifyScenario(LogicScenario $logicScenario) {
		$dbLogicScenarii = self::getValues ();
		foreach ( $logicScenario->conditions as $condition ) {
			if (LogicEvent::getLogicEventFromString ( $condition ) == FALSE) {
				return FALSE;
			}
		}
		foreach ( $logicScenario->actionsId as $action_id ) {
			if (DaoAction::getActionById ( $action_id ) === FALSE) {
				return FALSE;
			}
		}
		foreach ( $logicScenario->scenariiId as $logicScenario_id ) {
			if (DaoScenario::getScenarioByid ( $logicScenario_id ) === FALSE) {
				return FALSE;
			}
		}
		for ($i = 0; $i < sizeof($dbLogicScenarii); $i++) {
			if($dbLogicScenarii [$i][self::$INDEX_ID] == $logicScenario->id){
				$dbLogicScenarii [$i][self::$INDEX_DESCRIPTION] = $logicScenario->description;
				$dbLogicScenarii [$i][self::$INDEX_CONDITIONS] = $logicScenario->conditions;
				$dbLogicScenarii [$i][self::$INDEX_ACTIONS_ID] = $logicScenario->actionsId;
				$dbLogicScenarii [$i][self::$INDEX_SCENARII_ID] = $logicScenario->scenariiId;
				self::write ( $dbLogicScenarii );
				return $id;
			}
		}
		return FALSE;
	}
	/**
	 * Remove this action from logic scenarii
	 *
	 * @param int $actionId        	
	 * @return boolean
	 */
	public static function removeActionFromLogicScenarii($actionId) {
		$dbLogicScenarii = self::getValues ();
		if (empty ( $dbLogicScenarii )) {
			return TRUE;
		}
		for($i = 0; $i < sizeof ( $dbLogicScenarii ); $i ++) {
			for($j = 0; $j < sizeof ( $dbLogicScenarii [$i] [self::$INDEX_ACTIONS_ID] ); $j ++) {
				if ($dbLogicScenarii [$i] [self::$INDEX_ACTIONS_ID] [$j] == $actionId) {
					Logger::debug ( 'Deleting action ' . $actionId . ' in logicScenario with id ' . $dbLogicScenarii [$i] [self::$INDEX_ID] );
					array_splice ( $dbLogicScenarii [$i] [self::$INDEX_ACTIONS_ID], $j, 1 );
				}
			}
			for($j = 0; $j < sizeof ( $dbLogicScenarii [$i] [self::$INDEX_CONDITIONS] ); $j ++) {
				$condition = LogicEvent::getLogicEventFromString ( $dbLogicScenarii [$i] [self::$INDEX_CONDITIONS] [$j] );
				if ($condition === FALSE) {
					continue;
				}
				if ($condition->actionId == $actionId) {
					Logger::debug ( 'Deleting condition ' . $actionId . ' in logicScenario with id ' . $dbLogicScenarii [$i] [self::$INDEX_ID] );
					array_splice ( $dbLogicScenarii [$i] [self::$INDEX_CONDITIONS], $j, 1 );
				}
			}
		}
		self::write ( $dbLogicScenarii );
		return TRUE;
	}
	public static function removeScenarioFromLogicScenarii($scnearioId) {
		$dbLogicScenarii = self::getValues ();
		if (empty ( $dbLogicScenarii )) {
			return TRUE;
		}
		for($i = 0; $i < sizeof ( $dbLogicScenarii ); $i ++) {
			for($i = 0; $i < sizeof ( $dbLogicScenarii [$i] [self::$INDEX_SCENARII_ID] ); $i ++) {
				if ($dbLogicScenarii [$i] [self::$INDEX_SCENARII_ID] == $scnearioId) {
					Logger::debug ( 'Deleting action ' . $scnearioId . ' in logicScenario with id ' . $dbLogicScenarii [$i] [self::$INDEX_ID] );
					array_splice ( $dbLogicScenarii [$i] [self::$INDEX_SCENARII_ID], $i, 1 );
				}
			}
		}
		self::write ( $dbLogicScenarii );
		return TRUE;
	}
	/**
	 * Delete an existing logicScenario
	 *
	 * @param int $id        	
	 * @return boolean
	 */
	public static function delScenario($id) {
		$dbLogicScenarii = self::getValues ();
		if (empty ( $dbLogicScenarii )) {
			return FALSE;
		}
		for($i = 0; $i < sizeof ( $dbLogicScenarii ); $i ++) {
			if ($dbLogicScenarii [$i] [self::$INDEX_ID] == $id) {
				DaoSchedule::removeSchedulesWithLogic($id);
				array_splice ( $dbLogicScenarii, $i, 1 );
				self::write ( $dbLogicScenarii );
				Logger::debug ( "Deleting logicScenario with id " . $id );
				return true;
			}
		}
		Logger::warning ( 'LogicScenario ' . $id . ' does not exists in db' );
		return FALSE;
	}
	private static function getConditionObjectsFromStrings($conditionStrings) {
		$conditions = [ ];
		foreach ( $conditionStrings as $conditionString ) {
			$logicEvent = LogicEvent::getLogicEventFromString ( $conditionString );
			if ($logicEvent === FALSE) {
				return FALSE;
			}
			$conditions[] = $logicEvent;
		}
		return $conditions;
	}
}