<?php
class MulticastListener extends Daemon {
	public static $PROCESS_NAME = Configuration::APP_NAME . '-listener';
	private $socket;
	public function __construct() {
		// Ici on souhaite gérer les signaux SIGUSR1 et SIGUSR2 en plus
		parent::__construct ( self::$PROCESS_NAME, array (
				SIGUSR1,
				SIGUSR2 
		) );
		// Démarrage du démon
		if (! self::isRunning ()) {
			parent::start ();
		} else {
			echo 'Process already running !';
		}
	}
	public function run() {
		$buffer = SocketHelper::readUdpPacket ( $this->socket, $sip, $sport, 5000 );
		if (! empty ( $buffer )) {
			Logger::debug ( 'Packet received from ' . $sip . ' [ '. $buffer .' ]' );
			$module = self::getModuleFromIp ( $sip );
			if ($module === FALSE) {
				return FALSE;
			}
			if ($buffer === Configuration::MULTICAST_MSG_HELO) {
				DaoNotification::storeHelo ( $module->id );
			} else {
				if (strpos ( $buffer, ':' ) === FALSE) {
					// Unknown message
					Logger::debug ( 'Unknow message [ ' . $buffer . ' ]' );
				} else {
					$data = explode ( ':', $buffer );
					if (sizeof ( $data ) < 3) {
						Logger::warning ( 'Message does not contain necessary data [ ' . $buffer . ' ]' );
						return FALSE;
					}
					$notification;
					if ($data [0] == Configuration::MULTICAST_MSG_SERIAL) {
						// Serial event, remove first 'SERIAL' then process message
						$type = GpioNotification::TYPE_SERIAL;
						$moduleId = isset ( $data [1] ) ? $data [1] : '';
						$gpio = isset ( $data [2] ) ? $data [2] : '';
						$notification = new GpioNotification ( $moduleId, $gpio, $type, 0 );
					} else {
						$moduleId = $module->id;
						$type;
						if ($data [0] == Configuration::MULTICAST_MSG_STATE) {
							// Store gpio state modification
							$type = GpioNotification::TYPE_STATE;
						} else if ($data [0] == Configuration::MULTICAST_MSG_PWM) {
							// Store gpio PWM modification
							$type = GpioNotification::TYPE_PWM;
						} else if ($data [0] == Configuration::MULTICAST_MSG_ISR) {
							// Store gpio ISR event
							$type = GpioNotification::TYPE_ISR;
						}
						$gpio = isset ( $data [1] ) ? $data [1] : '';
						$value = isset ( $data [2] ) ? $data [2] : '';
						$notification = new GpioNotification ( $moduleId, $gpio, $type, $value );
						DaoNotification::storeGpioModification ( $notification );
					}
					LogicManager::checkIncomingNotification ( $notification );
				}
			}
		}
	}
	public function onStart() {
		Logger::setLogFile ( Configuration::LOG_DIR . '/' . Configuration::LOG_FILE_LISTENER );
		Logger::setLogLevel ( Configuration::LOG_LEVEL );
		Logger::debug ( 'Démarrage du processus avec le pid ' . getmypid () );
		Logger::debug ( 'Ecoute multicast sur ' . Configuration::MULTICAST_IP . ':' . Configuration::MULTICAST_PORT );
		$this->socket = SocketHelper::getMulticastSocket ( Configuration::MULTICAST_IP );
		socket_bind ( $this->socket, '0.0.0.0', Configuration::MULTICAST_PORT );
	}
	public function onStop() {
		Logger::debug ( 'Fermeture de la socket' );
		socket_close ( $this->socket );
		Logger::debug ( 'Arrêt du processus avec le pid ' . getmypid () );
	}
	public function handleOtherSignals($signal) {
		Logger::debug ( 'Signal non géré par la classe Daemon : ' . $signal );
	}
	private static function getModuleFromIp($sip) {
		$mac = ModuleManager::getModuleMacFromARP ( $sip );
		if ($mac !== FALSE) {
			return DaoModule::getModuleByMac ( $mac );
		}
		return DaoModule::getModuleByIp ( $sip );
	}
}