<?php
class CronManager {
	const SCHEDULER_URL = 'http://127.0.0.1/api/schedule';
	/**
	 * Add a line in the crontab
	 *
	 * @param Schedule $schedule        	
	 * @return boolean
	 */
	public static function addCron(Schedule $schedule) {
		if (self::isCron ( $schedule )) {
			Logger::warning ( 'Schedule already in crontab' );
			return FALSE;
		}
		$cronLine = self::getCronLine ( $schedule );
		$cronLines = self::getCronLines ();
		$cronLines[] = $cronLine;
		if (! self::writeCrontab ( $cronLines )) {
			Logger::fatal ( 'Fail adding schedule in crontab' );
			return FALSE;
		}
		Logger::info ( 'Adding cron job for schedule ' . $schedule->id );
		return TRUE;
	}
	/**
	 * Delete a line from the crontab
	 *
	 * @param Schedule $schedule        	
	 * @return boolean
	 */
	public static function deleteCron(Schedule $schedule) {
		$cronLines = self::getCronLines ();
		if ($cronLines === FALSE) {
			return FALSE;
		}
		$cronLine = self::getCronLine ( $schedule );
		for($i = 0; $i < sizeof ( $cronLines ); $i ++) {
			if ($cronLines [$i] == $cronLine) {
				Logger::info ( "Removing cron job for schedule " . $schedule->id );
				array_splice ( $cronLines, $i, 1 );
				self::writeCrontab($cronLines);
				break;
			}
		}
		Logger::info ( "Fail removing cron job for schedule " . $schedule->id );
		return FALSE;
	}
	/**
	 * Check if schedule is already in crontab
	 *
	 * @param Schedule $schedule        	
	 * @return boolean
	 */
	public static function isCron(Schedule $schedule) {
		$cronLines = self::getCronLines ();
		if ($cronLines === FALSE) {
			return FALSE;
		}
		if (strpos ( $cronLines, "\n" ) !== FALSE) {
			$cronLines = explode ( "\n", $cronLines );
			$cronLine = self::getCronLine ( $schedule );
			for($i = 0; $i < sizeof ( $cronLines ); $i ++) {
				if ($cronLines [$i] == $cronLine) {
					return TRUE;
				}
			}
		}
		return FALSE;
	}
	/**
	 * Generate the cron line
	 *
	 * @param Schedule $schedule        	
	 * @return string
	 */
	private static function getCronLine(Schedule $schedule) {
		$cmd = 'curl --silent --output /dev/null -X PUT -i ' . self::SCHEDULER_URL . '/' . $schedule->id;
		return trim ( $schedule->time . ' ' . $cmd );
	}
	/**
	 * Return all lines for 'crontab -l'
	 *
	 * @return boolean|string
	 */
	private static function getCronLines() {
		$cronLines = [ ];
		$ret;
		exec ( "crontab -l", $output, $ret );
		if ($ret != 0) {
			Logger::fatal ( "Fail reading crontab" );
			return FALSE;
		}
		return $output;
	}
	/**
	 * Write the crontab
	 * 
	 * @param string $cronLines        	
	 * @return boolean
	 */
	private static function writeCrontab($cronLines) {
		if(is_array($cronLines)){
			$cronLines = implode(PHP_EOL, $cronLines);
		}
		$output = [ ];
		$ret;
		exec ( 'echo "' . $cronLines . '" | crontab -', $output, $ret );
		if ($ret != 0) {
			return FALSE;
		}
		return TRUE;
	}
}