<?php
class ApiSchedule extends Api {
	private static $URL_ACTIVATE = 'activate';
	private static $PARAM_TASK_ID = 'taskId';
	private static $PARAM_TASK_TYPE = 'taskType';
	private static $PARAM_ACTIVE = 'active';
	private static $PARAM_TIME = 'time';
	/**
	 * Executed during GET
	 */
	static function executeGet() {
		$url = self::getCleanUrl ();
		if ($url === '') {
			$schedules = DaoSchedule::getSchedules ();
			return self::response ( self::$CODE_OK, json_encode ( $schedules ) );
		} else if (is_numeric ( $url )) {
			$schedule = DaoSchedule::getScheduleById ( $url );
			if ($schedule !== FALSE) {
				return self::response ( self::$CODE_OK, json_encode ( $schedule ) );
			}
		} else {
			logger::warning ( 'Bad request' );
		}
		return self::response ();
	}
	/**
	 * Executed during POST
	 */
	static function executePost() {
		$url = self::getCleanUrl ();
		$idSchedule = null;
		if (! empty ( $url )) {
			$idSchedule = $url;
		}
		$taskId = HttpHelper::postVar ( self::$PARAM_TASK_ID );
		$taskType = HttpHelper::postVar ( self::$PARAM_TASK_TYPE );
		$active = HttpHelper::postVar(self::$PARAM_ACTIVE);
		$time = HttpHelper::postVar ( self::$PARAM_TIME );
		if (is_bool ( $taskId )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_TASK_ID );
			return self::response ();
		}
		if (is_bool ( $taskType )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_TASK_TYPE );
			return self::response ();
		}
		if (is_bool ( $time )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_TIME );
			return self::response ();
		}
		if (is_bool ( $active )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_ACTIVE );
			return self::response ();
		}
		$schedule = new Schedule ( $taskId, $taskType, $time, $active, $idSchedule );
		if(isset($idSchedule)){
			$idSchedule = DaoSchedule::modifySchedule($schedule);
		}else{
			$idSchedule = DaoSchedule::addSchedule($schedule);
		}
		if ($idSchedule === FALSE) {
			return self::response ();
		}
		return self::response ( self::$CODE_OK, '{ id : ' . $id . ' }' );
	}
	/**
	 * Executed during PUT
	 */
	static function executePut() {
		$url = self::getUrlParameter ( 0 );
		if (empty ( $url ) && $url !== '0') {
			Logger::warning ( 'Missing parameter' );
			return self::response ();
		}
		if ($url == self::$URL_ACTIVATE) {
			$scheduleId = self::getUrlParameter ( 1 );
			if ($scheduleId !== FALSE) {
				$isActivated = HttpHelper::putVar(self::$PARAM_ACTIVE);
				if(is_bool($isActivated)){
					Logger::warning ( 'missing parameter ' . self::$PARAM_ACTIVE );
					return self::response ();
				}
				if(DaoSchedule::activateSchedule($scheduleId, $isActivated === '1')){
					return self::response ( self::$CODE_OK );
				}
			}
		} else if (is_numeric ( $url )) {
			$scheduleId = self::getUrlParameter ( 0 );
			if ($scheduleId !== FALSE) {
				$schedule = DaoSchedule::getScheduleByid ( $scheduleId );
				if ($schedule !== FALSE) {
					Logger::info ( 'Executing schedule ' . $scheduleId );
					$url = 'http://127.0.0.1/' . HttpHelper::getBaseUrl ();
					if ($schedule->taskType == Schedule::TASK_TYPE_ACTION) {
						$url .= '/api/action/' . $schedule->taskId;
					} else if ($schedule->taskType == Schedule::TASK_TYPE_SCENARIO) {
						$url .= '/api/scenario/' . $schedule->taskId;
					} else if ($schedule->taskType == Schedule::TASK_TYPE_LOGIC) {
						$url .= '/api/logic/' . $schedule->taskId;
					}
					$code = 0;
					HttpHelper::sendHttpRequest($url, $code, 'PUT');
					if ($code == 200) {
						return self::response ( self::$CODE_OK );
					}
				}
			}
		}
		return self::response ();
	}
	/**
	 * Executed during DELETE
	 */
	static function executeDelete() {
		$url = self::getCleanUrl ();
		if (is_bool ( $url )) {
			return self::response ();
		}
		if (is_numeric ( $url )) {
			$schedule = DaoSchedule::delSchedule ( $url );
			if ($schedule !== FALSE) {
				return self::response ( self::$CODE_OK );
			}
		}
		return self::response ();
	}
}