<?php
class ApiRemote extends Api {
	private static $PARAM_ID = 'remoteId';
	private static $PARAM_DESCRIPTION = 'description';
	private static $PARAM_SERIAL = 'serial';
	private static $PARAM_NB_BUTTON = 'nbButton';
	/**
	 * Executed during GET
	 */
	static function executeGet() {
		$url = self::getCleanUrl ();
		if ($url === '') {
			$remotes = DaoRemote::getRemotes ();
			return self::response ( self::$CODE_OK, json_encode ( $remotes ) );
		}
		$remote = DaoRemote::getRemoteById ( $url );
		if ($remote !== FALSE) {
			return self::response ( self::$CODE_OK, json_encode ( $remote ) );
		}
		logger::warning ( 'Bad request' );
		return self::response ();
	}
	/**
	 * Executed during POST
	 */
	static function executePost() {
		$url = self::getCleanUrl ();
		$idRemote = null;
		if (! empty ( $url )) {
			$idRemote = $url;
		}
		$serial = HttpHelper::postVar ( self::$PARAM_SERIAL );
		$descrption = HttpHelper::postVar ( self::$PARAM_DESCRIPTION );
		$nbButton = HttpHelper::postVar ( self::$PARAM_NB_BUTTON );
		if (is_bool ( $serial )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_SERIAL );
			return self::response ();
		}
		if (is_bool ( $descrption )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_DESCRIPTION );
			return self::response ();
		}
		if (is_bool ( $nbButton )) {
			Logger::warning ( 'missing parameter ' . self::$PARAM_NB_BUTTON );
			return self::response ();
		}
		$remote = new RemoteModule ( $serial, $descrption, $nbButton, $idRemote );
		if (isset ( $idRemote )) {
			$idRemote = DaoRemote::modifyRemote ( $remote );
		} else {
			$idRemote = DaoRemote::addRemote ( $remote );
		}
		if ($idRemote === FALSE) {
			return self::response ();
		}
		return self::response ( self::$CODE_OK, '{ id : ' . $idRemote . ' }' );
	}
	/**
	 * Executed during PUT
	 */
	static function executePut() {
		return self::response ( self::$CODE_NOT_IMPLEMENTED );
	}
	/**
	 * Executed during DELETE
	 */
	static function executeDelete() {
		$url = self::getCleanUrl ();
		if (is_bool ( $url )) {
			return self::response ();
		}
		$remote = DaoRemote::delRemote ( $url );
		if ($remote !== FALSE) {
			return self::response ( self::$CODE_OK );
		}
		return self::response ();
	}
}