<?php
class ApiModule extends Api {
	const URL_SCAN = 'scan';
	const URL_CHECK = 'check';
	const URL_CONF = 'conf';
	const URL_MAC = 'mac';
	
	/**
	 * Executed during GET
	 */
	static function executeGet() {
		$url = self::getCleanUrl ();
		if ($url === '') {
			$modules = DaoModule::getModules ();
			return self::response ( self::$CODE_OK, json_encode ( $modules ) );
		}
		if ($url === self::URL_SCAN) {
			$modules = ModuleManager::retrieveNeighbours ();
			return self::response ( self::$CODE_OK, json_encode ( $modules ) );
		} else if (is_numeric ( $url )) {
			$module = DaoModule::getModuleById ( $url );
			if ($module !== FALSE) {
				return self::response ( self::$CODE_OK, json_encode ( $module ) );
			}
		} else {
			$url = self::getUrlParameter ( 0 );
			if ($url === self::URL_CONF) {
				$ip = self::getUrlParameter ( 1 );
				if (! empty ( $ip )) {
					$config = ModuleManager::retrieveConfiguration ( $ip );
					return self::response ( self::$CODE_OK, json_encode ( $config ) );
				}
				Logger::warning ( 'Missing parameter ip' );
			} else if ($url === self::URL_MAC) {
				$ip = self::getUrlParameter ( 1 );
				if (! empty ( $ip )) {
					$mac = ModuleManager::getModuleMacFromARP ( $ip );
					return self::response ( self::$CODE_OK, json_encode ( $mac ) );
				}
				Logger::warning ( 'Missing parameter ip' );
			}
			Logger::warning ( 'bad request' );
		}
		return self::response ();
	}
	/**
	 * Executed during POST
	 */
	static function executePost() {
		if (empty ( self::getCleanUrl () )) {
			return self::response ();
		}
		$url = self::getCleanUrl ();
		if ($url === self::URL_SCAN) {
			$modules = ModuleManager::retrieveNeighbours ();
			$addedModules = [ ];
			foreach ( $modules as $module ) {
				if (DaoModule::getModuleByMac ( $module->mac ) === FALSE) {
					$id = DaoModule::addModule ( $module );
					if ($id !== FALSE) {
						$module->id = $id;
						$addedModules [] = $module;
					}
				}
			}
			return self::response ( self::$CODE_OK, json_encode ( $addedModules ) );
		} else if ($url === self::URL_CHECK) {
			$updated = [ ];
			$missing = [ ];
			$unchanged = [ ];
			ModuleManager::checkModules ( $updated, $missing, $unchanged );
			return self::response ( self::$CODE_OK, json_encode ( [ 
					'updated' => $updated,
					'missing' => $missing,
					'unchanged' => $unchanged 
			] ) );
		} else {
			Logger::warning ( 'bad request' );
		}
		return self::response ();
	}
	/**
	 * Executed during PUT
	 */
	static function executePut() {
		return self::response ( self::$CODE_NOT_IMPLEMENTED );
	}
	/**
	 * Executed during DELETE
	 */
	static function executeDelete() {
		$url = self::getCleanUrl ();
		if (is_bool ( $url )) {
			return self::response ();
		}
		if (is_numeric ( $url )) {
			$module = DaoModule::delModule ( $url );
			if ($module !== FALSE) {
				return self::response ( self::$CODE_OK );
			}
		}
		return self::response ();
	}
}