<?php
/**
 *
 * @author Tala
 *
 */
abstract class Api {
	protected static $CODE_OK = 200;
	protected static $CODE_CREATED = 201;
	protected static $CODE_BAD_REQUEST = 400;
	protected static $CODE_UNAUTHORIZED = 401;
	protected static $CODE_NOT_FOUND = 404;
	protected static $CODE_INTERNAL_SERVER_ERROR = 500;
	protected static $CODE_NOT_IMPLEMENTED = 501;
	
	/**
	 * Return $_SERVER["REQUEST_METHOD"]
	 *
	 * @return boolean|string
	 */
	protected static function getMethod() {
		return HttpHelper::serverVar ( "REQUEST_METHOD" );
	}
	
	/**
	 * Return $_SERVER["REMOTE_ADDR"]
	 *
	 * @return boolean|string
	 */
	protected static function getSourceIp() {
		return HttpHelper::serverVar ( "REMOTE_ADDR" );
	}
	
	/**
	 * Return $_SERVER["REMOTE_PORT"]
	 *
	 * @return boolean|string
	 */
	protected static function getSourcePort() {
		return HttpHelper::serverVar ( "REMOTE_PORT" );
	}
	
	/**
	 * Return the remaining URL parts
	 *
	 * @return string
	 */
	protected static function getCleanUrl() {
		$parts = explode ( "/", HttpHelper::getUrl () );
		if (sizeof ( $parts ) > 3) {
			array_splice ( $parts, 0, 2 );
			return implode ( "/", $parts );
		}
		if (sizeof ( $parts ) == 3) {
			return $parts [2];
		}
		return '';
	}
	
	/**
	 * Return the requested parameter in URL or an empty string
	 *
	 * eg. /share/list/san/music
	 * <ul>
	 * <li>getUrlParameter(1) &rarr; list</li>
	 * <li>getUrlParameter(2) &rarr; san</li>
	 * <li>getUrlParameter(3) &rarr; music</li>
	 * <li>getUrlParameter(4) &rarr; ""</li>
	 * </ul>
	 *
	 * @param number $index
	 * @return string|mixed
	 */
	protected static function getUrlParameter($index) {
		if (self::getCleanUrl () !== '') {
			$parts = explode ( '/', self::getCleanUrl () );
			if (! empty ( $parts ) && $index < sizeof ( $parts )) {
				return $parts [$index];
			}
		}
		return false;
	}
	
	/**
	 * Return the given message in json format or the last error in text
	 * By default :
	 * <br>
	 * <ul>
	 * <li>$code = $CODE_BAD_REQUEST</li>
	 * <li>$message = Logger::getLastMessage()</li>
	 * </ul>
	 *
	 * @param string $code
	 * @param string $message
	 * @return boolean
	 */
	protected static function response($code = "", $content = "") {
		if (! self::isHeader ( 'Content-Type' )) {
			header ( 'Content-Type: application/json' );
		}
		$code = empty ( $code ) ? self::$CODE_BAD_REQUEST : $code;
		http_response_code ( $code );
		if ($code === self::$CODE_OK || $code === self::$CODE_CREATED) {
			if (! empty ( $content )) {
				echo $content;
			}
			return true;
		}
		$content = empty ( $content ) ? Logger::getLastMessage () : $content;
		echo '{"error":"' . Logger::getLastMessage () . '"}';
		return false;
	}
	
	/**
	 * Executed during GET
	 */
	protected static abstract function executeGet();
	
	/**
	 * Executed during POST
	 */
	protected static abstract function executePost();
	
	/**
	 * Executed during PUT
	 */
	protected static abstract function executePut();
	
	/**
	 * Executed during DELETE
	 */
	protected static abstract function executeDelete();
	
	/**
	 * Main function
	 */
	public static function execute() {
		Logger::log('Inbound [ '.self::getMethod ().' ] request. [ '.HttpHelper::getUrl().' ]');
		if (self::getMethod () === "GET") {
			return static::executeGet ();
		} else if (self::getMethod () === "POST") {
			return static::executePost ();
		} else if (self::getMethod () === "PUT") {
			return static::executePut ();
		} else if (self::getMethod () === "DELETE") {
			return static::executeDelete ();
		}
		return false;
	}
	
	/**
	 * True if header is already setted
	 *
	 * @param string $header
	 * @return boolean
	 */
	private static function isHeader($header) {
		foreach ( headers_list () as $h ) {
			if (strpos ( $h, $header ) !== FALSE) {
				return TRUE;
			}
		}
		return FALSE;
	}
}