/*
 * HttpConfigServer.cpp
 *
 *  Created on: 16 sept. 2017
 *      Author: Deejc
 */

#include <EspHttpServer.h>

constexpr char EspHttpServer::URL_BASE[];

ESP8266WebServer* EspHttpServer::server;

void EspHttpServer::setup(ESP8266WebServer* server) {
#ifdef SERIAL_DEBUG
		Serial.begin(115200);
		delay(50);
		Serial.println(F("\n"));
#endif
	this->server = server;
	this->aconfs.setup(server);
	this->agpios.setup(server);
	this->acmds.setup(server);
	this->ads.setup(server);
	server->on(URL_BASE, displayHtml);
	server->begin();
}

void EspHttpServer::loop() {
	this->server->handleClient();
	this->agpios.loop();
	this->acmds.loop();
	this->ads.loop();
}

void EspHttpServer::displayHtml() {
	server->send(200, F("text/html"),
			F("<html><head><title>Esp Manager</title><meta charset='utf8' /><style>html{display: table;margin: auto;}body{display: table-cell;vertical-align: middle;}table{width: 100%;}td{text-align: center;vertical-align: top;}.header{width: 50%;text-align: left;font-family: sans-serif;font-weight: bold;}.title{border-bottom: 1px solid black;border-top: 1px solid black;}.title{text-align: center;font-family: sans-serif;font-weight: bold;}.input_text{width: 40px;text-align: center;}.input_ip{width: 110px;text-align: center;}.align-left{text-align: left;}.button_table{border-top: 1px solid black;}.button_table tr{vertical-align: middle;}.button_table tr td{text-align: left;vertical-align: middle;}.div_label{position: absolute;display: inline-block;cursor: pointer;}.switch, button{position: relative;display: inline-block;width: 60px;height: 25px;cursor: pointer;}.switch input{display: none;}.slider{position: absolute;cursor: pointer;top: 0;left: 0;right: 0;bottom: 0;background-color: #ccc;-webkit-transition: .4s;transition: .4s;}.slider:before{position: absolute;content: '';height: 18px;width: 20px;left: 4px;bottom: 4px;background-color: white;-webkit-transition: .4s;transition: .4s;}input:checked+.slider{background-color: #2196F3;}input:focus+.slider{box-shadow: 0 0 1px #2196F3;}input:checked+.slider:before{-webkit-transform: translateX(31px);-ms-transform: translateX(31px);transform: translateX(31px);}.slider.round, button{border-radius: 34px;}.slider.round:before{border-radius: 50%;}.sliderRange{content: '';height: 25px;width: 85%;background-color: white;box-shadow: 0 0 1px #2196F3;background-color: #ccc;cursor: pointer;border-radius: 34px;}.sliderRange::-webkit-slider-thumb{-webkit-appearance: none;appearance: none;width: 26px;height: 18px;background-color: white;cursor: pointer;border-radius: 34px;}.sliderRange::-moz-range-thumb{width: 26px;height: 18px;background-color: white;cursor: pointer;border-radius: 34px;}.status{width: 100%;height: 18px;text-align: right;font-family: sans-serif;font-weight: bold;}ul{list-style-type: none;margin: 0;padding: 0;overflow: hidden;background-color: #333;}li{float: left;width: 200px}li a{display: block;color: white;text-align: center;padding: 12px;text-decoration: none;}li a:hover{background-color: #111;}</style></head><body onload='load();'><table class='title'><tr><td class='header'>ESP configuration page</td><td class='status' id='statusMsg'></td></tr></table><table id='menu'><tr><td><ul><li><a id='m1' onclick='displayPage(this.id)'>Configuration</a></li><li><a id='m2' onclick='displayPage(this.id)'>GPIO management</a></li><li><a id='m3' onclick='displayPage(this.id)'>Commands</a></li></ul></td></tr></table><table id='content' style='visibility: hidden;'><tr><td><div id='page_gpio'><table class='pins'><tr><td colspan='10' class='title'>GPIO management</td></tr><tr><td>GPIO</td><td>D0(16)</td><td>D1(5)</td><td>D2(4)</td><td>D3(0)</td><td>D4(2)</td><td>D5(14)</td><td>D6(12)</td><td>D7(13)</td><td>D8(14)</td></tr><tr><td>State</td><td><label class='switch'><input type='checkbox' id='D0' onclick='sendGpioValue(this.id)'><span class='slider round'></span></label></td><td><label class='switch'><input type='checkbox' id='D1' onclick='sendGpioValue(this.id)'><span class='slider round'></span></label></td><td><label class='switch'><input type='checkbox' id='D2' onclick='sendGpioValue(this.id)'><span class='slider round'></span></label></td><td><label class='switch'><input type='checkbox' id='D3' onclick='sendGpioValue(this.id)'><span class='slider round'></span></label></td><td><label class='switch'><input type='checkbox' id='D4' onclick='sendGpioValue(this.id)'><span class='slider round'></span></label></td><td><label class='switch'><input type='checkbox' id='D5' onclick='sendGpioValue(this.id)'><span class='slider round'></span></label></td><td><label class='switch'><input type='checkbox' id='D6' onclick='sendGpioValue(this.id)'><span class='slider round'></span></label></td><td><label class='switch'><input type='checkbox' id='D7' onclick='sendGpioValue(this.id)'><span class='slider round'></span></label></td><td><label class='switch'><input type='checkbox' id='D8' onclick='sendGpioValue(this.id)'><span class='slider round'></span></label></td></tr><tr><td>Toggle</td><td><button name='D0' onclick='sendToggle(this.name)'>D0</button></td><td><button name='D1' onclick='sendToggle(this.name)'>D1</button></td><td><button name='D2' onclick='sendToggle(this.name)'>D2</button></td><td><button name='D3' onclick='sendToggle(this.name)'>D3</button></td><td><button name='D4' onclick='sendToggle(this.name)'>D4</button></td><td><button name='D5' onclick='sendToggle(this.name)'>D5</button></td><td><button name='D6' onclick='sendToggle(this.name)'>D6</button></td><td><button name='D7' onclick='sendToggle(this.name)'>D7</button></td><td><button name='D8' onclick='sendToggle(this.name)'>D8</button></td></tr><tr><td>Timer</td><td><input class='input_text' type='text' maxlength='5' id='D0_time' min='0' onkeypress='sendGpioTime(event,this)'></td><td><input class='input_text' type='text' maxlength='5' id='D1_time' min='0' onkeypress='sendGpioTime(event,this)'></td><td><input class='input_text' type='text' maxlength='5' id='D2_time' min='0' onkeypress='sendGpioTime(event,this)'></td><td><input class='input_text' type='text' maxlength='5' id='D3_time' min='0' onkeypress='sendGpioTime(event,this)'></td><td><input class='input_text' type='text' maxlength='5' id='D4_time' min='0' onkeypress='sendGpioTime(event,this)'></td><td><input class='input_text' type='text' maxlength='5' id='D5_time' min='0' onkeypress='sendGpioTime(event,this)'></td><td><input class='input_text' type='text' maxlength='5' id='D6_time' min='0' onkeypress='sendGpioTime(event,this)'></td><td><input class='input_text' type='text' maxlength='5' id='D7_time' min='0' onkeypress='sendGpioTime(event,this)'></td><td><input class='input_text' type='text' maxlength='5' id='D8_time' min='0' onkeypress='sendGpioTime(event,this)'></td></tr><tr style='border-top: 1px solid black;'><td>PWM</td><td><select id='pwm_gpio'><option value='D0'>D0</option><option value='D1'>D1</option><option value='D2'>D2</option><option value='D3'>D3</option><option value='D4'>D4</option><option value='D5'>D5</option><option value='D6'>D6</option><option value='D7'>D7</option><option value='D8'>D8</option></select></td><td colspan='8'><input type='range' min='0' max='1023' value='0' class='sliderRange' id='pwmSlide' onchange='readPwm(false)' oninput='readPwm();'></td></tr><tr><td colspan='2'></td><td>0</td><td colspan='2'></td><td colspan='2'><input class='input_text' type='text' id='pwmText' onkeypress='readPwm(event)' value='0'></td><td colspan='2'></td><td>1023</td></tr></table></div><div id='page_conf'><table><tr><td class='title' colspan='4'>Global</td></tr><tr><td class='align-left'>MAC :<span id='mac'></span></td><td class='align-left'>Channel :<span id='channel'></span></td><td>Device name(4-20 caracters)</td><td colspan='3'>WiFi mode</td></tr><tr><td class='align-left'>Uptime :<span id='uptime'></span></td><td class='align-left'>RSSI :<span id='rssi'>n/a</span></td><td><input type='text' name='hostname' id='hostname' required pattern='.{4,20}'></td><td><table><tr><td>sta</td><td>ap</td><td>both</td></tr><tr><td><input type='radio' name='wifimode' value='1' checked='checked' onchange='hideFields();'></td><td><input type='radio' name='wifimode' value='2' onchange='hideFields();'></td><td><input type='radio' name='wifimode' value='3' onchange='hideFields();'></td></tr></table></td></tr><tr><td class='align-left'>BSSID :<span id='bssid'>n/a</span></td><td></td><td style='text-align: center'>Disable module ?<br><label class='switch'><input type='checkbox' id='disabled' onclick='enable();'><span class='slider round'></span></label></td><td></td></tr></table><table><tr><td><table id='ap_table'><tr><td class='title' colspan='2'>Access Point</td></tr><tr><td>WiFi name<br>(4-20 caracters)</td><td><input type='text' name='ap_ssid' id='ap_ssid' required pattern='.{4,20}'></td></tr><tr><td>WiFi key<br>(8-20 caracters)</td><td><input type='password' name='ap_pwd' id='ap_pwd' required pattern='.{8,20}'></td></tr><tr><td>Output power<br>(0-20 dBm)</td><td><input class='input_text' type='text' name='ap_pwr' id='ap_pwr' required pattern='.{0,20}'>dBm</td></tr><tr><td>IP address<br></td><td><span id='ap_ip'></span></td></tr></table></td><td><table id='sta_table'><tr><td class='title' colspan='3'>Station</td></tr><tr><td>WiFi name<br>(4-20 caracters)</td><td><input type='text' name='sta_ssid' id='sta_ssid' required pattern='.{4,20}'></td><td>IP configuration</td></tr><tr><td>WiFi key<br>(8-20 caracters)</td><td><input type='password' name='sta_pwd' id='sta_pwd' required pattern='.{8,20}'></td><td><table><tr style='width: 100%'><td><input type='radio' name='ipconfig' value='0' onchange='hideFields();' checked='checked' id='dhcp'></td><td><input type='radio' name='ipconfig' value='1' onchange='hideFields();'></td></tr><tr style='width: 100%'><td>dhcp</td><td>static</td></tr></table></td></tr><tr><td colspan='3'><table id='ip_table'><tr><td>IP address</td><td>Netmask</td><td>Gateway</td><td>DNS</td></tr><tr><td><input class='input_ip' type='text' name='ipaddr' id='ipaddr' required pattern='^([0-9]{1,3}\.){3}[0-9]{1,3}$'></td><td><input class='input_ip' type='text' name='netmask' id='netmask' required pattern='^([0-9]{1,3}\.){3}[0-9]{1,3}$'></td><td><input class='input_ip' type='text' name='gateway' id='gateway' required pattern='^([0-9]{1,3}\.){3}[0-9]{1,3}$'></td><td><input class='input_ip' type='text' name='dns' id='dns' required pattern='^([0-9]{1,3}\.){3}[0-9]{1,3}$'></td></tr></table></td></table></td></tr></table><table class='button_table'><tr><td>Apply configuration ?<br><label class='switch' style='margin-left: 10%'><input type='checkbox' name='to_apply' id='to_apply' checked><span class='slider round'></span></label></td><td width='30%'></td><td style='text-align: center'><button onclick='validate();' style='width: 100%'>SAVE</button></td></tr></table></div><div id='page_cmd'><table><tr><td colspan='10' class='title'>Commands</td></tr><tr><td><button onclick='locate();' style='width: 100%'>LOCATE</button></td><td><button onclick='reboot();' style='width: 100%'>REBOOT</button></td><td><button onclick='reset();' style='width: 100%'>RESET</button></td></tr></table></div></td></tr></table><script type='text/javascript' >var hostname=document.getElementById('hostname');var disabled=document.getElementById('disabled');var sta_pwd=document.getElementById('sta_pwd');var sta_ssid=document.getElementById('sta_ssid');var ap_ssid=document.getElementById('ap_ssid');var ap_pwd=document.getElementById('ap_pwd');var ap_pwr=document.getElementById('ap_pwr');var ipaddr=document.getElementById('ipaddr');var netmask=document.getElementById('netmask');var gateway=document.getElementById('gateway');var dns=document.getElementById('dns');var pwmSlider=document.getElementById('pwmSlide');var pwmText=document.getElementById('pwmText');var pwm_gpio=document.getElementById('pwm_gpio');var page_gpio=document.getElementById('page_gpio');var page_conf=document.getElementById('page_conf');var page_cmd=document.getElementById('page_cmd');var timed=[];var URL_API='/api';var URL_CONF=URL_API+'/conf';var URL_GPIO=URL_API+'/gpio';var URL_CMD=URL_API+'/cmd';var URL_CONF_SAVE=URL_CONF+'/save';var URL_CONF_RESET=URL_CONF+'/reset';var URL_GPIO_TIME=URL_GPIO+'/time';var URL_GPIO_STATE=URL_GPIO+'/state';var URL_GPIO_TOGGLE=URL_GPIO+'/toggle';var URL_GPIO_PWM=URL_GPIO+'/pwm';var URL_CMD_LOCATE=URL_CMD+'/locate';var URL_CMD_REBOOT=URL_CMD+'/reboot';var URL_CMD_DISABLE=URL_CMD+'/disable';var URL_CMD_ENABLE=URL_CMD+'/enable';var timerValue=0;function load(){readConfiguration();readGpioData();displayPage('m1');setInterval(decreaseTimer, 1000);}function displayPage(id){if(id=='m1'){page_gpio.style.visibility='collapse';page_cmd.style.visibility='collapse';page_conf.style.visibility='visible';}else if(id=='m2'){readGpioData();page_conf.style.visibility='collapse';page_cmd.style.visibility='collapse';page_gpio.style.visibility='visible';}else if(id=='m3'){page_conf.style.visibility='collapse';page_gpio.style.visibility='collapse';page_cmd.style.visibility='visible';}}function hideFields(){var wifimode=document.querySelector('input[name=wifimode]:checked').value;if(wifimode==1){sta_pwd.disabled=false;sta_ssid.disabled=false;ap_pwd.disabled=true;ap_ssid.disabled=true;}else if(wifimode==2){sta_pwd.disabled=true;sta_ssid.disabled=true;ap_pwd.disabled=false;ap_ssid.disabled=false;}else{sta_pwd.disabled=false;sta_ssid.disabled=false;ap_pwd.disabled=false;ap_ssid.disabled=false;}var ipmode=document.querySelector('input[name=ipconfig]:checked').value==0;if(wifimode==2 || ipmode){ipaddr.disabled=true;netmask.disabled=true;gateway.disabled=true;dns.disabled=true;}else{ipaddr.disabled=false;netmask.disabled=false;gateway.disabled=false;dns.disabled=false;}}function validate(){if(0==hostname.value.length){alert('Name cannot be empty !');hostname.select();return false;}var params='?hostname='+hostname.value;var isDisabled=disabled.checked;if(isDisabled){if(!confirm('If module is disabled, no gpio can be modified. Are you sure ?')){return false;}}params+='&disabled='+(isDisabled ? '1' : '0');var wifimode=document.querySelector('input[name=wifimode]:checked').value;params+='&wifimode='+wifimode;if(wifimode==2 || wifimode==3){if(0==ap_ssid.value.length){alert('Access point WiFi name cannot be empty !');ap_ssid.select();return false;}else if(0==ap_pwd.value.length){alert('Access point WiFi password cannot be empty !');ap_pwd.select();return false;}else if(0==ap_pwr.value.length){alert('Access point WiFi power cannot be empty !');ap_pwr.select();return false;}params+='&ap_ssid='+ap_ssid.value+'&ap_pwd='+ap_pwd.value+'&ap_pwr='+ap_pwr.value;}if(wifimode==1 || wifimode==3){if(0==sta_ssid.value.length){alert('Station WiFi name cannot be empty !');sta_ssid.select();return false;}else if(0==sta_pwd.value.length){if(!confirm('Station WiFi password is empty, old password will be used ?')){sta_pwd.select();return false;}}params+='&sta_ssid='+sta_ssid.value;if(0 !=sta_pwd.value.length){params+='&sta_pwd='+sta_pwd.value;}var ipconfig=document.querySelector('input[name=ipconfig]:checked').value;params+='&ipconfig='+ipconfig;if(ipconfig==1){if(0==ipaddr.value.length){alert('Station ip address cannot be empty !');ipaddr.select();return false;}else if(0==netmask.value.length){alert('Station mask cannot be empty !');netmask.select();return false;}else if(0==gateway.value.length){alert('Station gateway address cannot be empty !');gateway.select();return false;}else if(0==dns.value.length){if(!confirm('Station dns cannot be empty to access the Internet !')){dns.select();return false;}}params+='&ipaddr='+ipaddr.value+'&netmask='+netmask.value+'&gateway='+gateway.value+'&dns='+dns.value;}}if(document.getElementById('to_apply').checked){params+='&to_apply=';}var xhr=new XMLHttpRequest();xhr.open('GET', URL_CONF_SAVE+params, true);xhr.onprogress=function(){updateStatus('Saving configuration...');};xhr.onload=function(){if(xhr.status==200){updateStatus('Configuration saved');}else{updateStatus('Fail saving configuration...');}};xhr.send();return true;}function readPwm(event){if(document.activeElement.id=='pwmSlide'){pwmText.value=pwmSlider.value;clearTimeout(timerValue);timerValue=setTimeout(sendGpioPwm, 500);}else if(typeof event !=='undefined' && event.keyCode===13){if(pwmText.value<0){pwmText.value=0;}if(pwmText.value>1023){pwmText.value=1023;}pwmSlider.value=pwmText.value;sendGpioPwm();}}function updateStatus(msg){var statusMsg=document.getElementById('statusMsg');if(typeof msg=='undefined'){statusMsg.innerHTML='';}else{statusMsg.innerHTML=msg;clearTimeout(timerValue);timerValue=setTimeout(updateStatus, 3000);}}function sendGpioValue(gpioId){var gpio=document.getElementById(gpioId);var state=gpio.checked==true ? '1' : '0';var xhr=new XMLHttpRequest();xhr.open('GET', URL_GPIO_STATE+'?gpio='+gpioId+'&state='+state, true);xhr.onprogress=function(){updateStatus('Changing '+gpioId+' state...');};xhr.onload=function(){var msgState=state=='1' ? 'HIGH' : 'LOW';if(xhr.status==200){updateStatus(gpioId+' state changed to '+msgState);}else{gpio.checked=!gpio.checked;updateStatus(gpioId+' update failed !');}};xhr.send();}function sendToggle(gpioId){var xhr=new XMLHttpRequest();xhr.open('GET', URL_GPIO_TOGGLE+'?gpio='+gpioId, true);xhr.onprogress=function(){updateStatus('Toggling '+gpioId+' state...');};xhr.onload=function(){if(xhr.status==200){response=JSON.parse(xhr.responseText);strSate=response.state==1 ? 'HIGH' : 'LOW';updateStatus(gpioId+' state toggled to '+strSate);var gpio=document.getElementById(gpioId);gpio.checked=response.state==1;}else{updateStatus(gpioId+' update failed !');}};xhr.send();}function sendGpioTime(event, inputElement){if(event.keyCode !==13){return false;}var gpioId=inputElement.id.split('_')[0];if(inputElement.value>65535){inputElement.value=65535}else if(inputElement.value<0){inputElement.value=-1;return false;}var xhr=new XMLHttpRequest();xhr.open('GET', URL_GPIO_TIME+'?gpio='+gpioId+'&time='+inputElement.value, true);xhr.onprogress=function(){updateStatus('Changing '+gpioId+' timer...');};xhr.onload=function(){if(xhr.status==200){updateStatus(gpioId+' timer setted to '+inputElement.value);document.getElementById(gpioId).checked=!document .getElementById(gpioId).checked;timed[gpioId]=true;}else{updateStatus(gpioId+' update failed !');}};xhr.send();}function sendGpioPwm(){var gpioId=pwm_gpio.options[pwm_gpio.selectedIndex].value;var pwm=pwmText.value;var xhr=new XMLHttpRequest();xhr.open('GET', URL_GPIO_PWM+'?gpio='+gpioId+'&pwm='+pwm, true);xhr.onprogress=function(){updateStatus('Changing '+gpioId+' PWM...');};xhr.onload=function(){if(xhr.status==200){updateStatus(gpioId+' PWM setted to '+pwm);}else{updateStatus(gpioId+' PWM update failed !');}};xhr.send();}function locate(){var xhr=new XMLHttpRequest();xhr.open('GET', URL_CMD_LOCATE, true);xhr.onprogress=function(){updateStatus('Sending location command...');};xhr.onload=function(){updateStatus('Module is blinking...');};xhr.send();}function reboot(){if(!confirm('Are you sure you want to reboot the module ?')){return false;}var xhr=new XMLHttpRequest();xhr.open('GET', URL_CMD_REBOOT, true);xhr.onprogress=function(){updateStatus('Sending reboot command...');};xhr.onload=function(){updateStatus('Module is rebooting...');};xhr.send();}function reset(){if(!confirm('Are you sure you want to reset module configuration ?')){return false;}var xhr=new XMLHttpRequest();xhr.open('GET', URL_CONF_RESET, true);xhr.onprogress=function(){updateStatus('Sending reset command...');};xhr.onload=function(){updateStatus('Module is resetting...');};xhr.send();}function enable(){var url=disabled.checked ? URL_CMD_DISABLE : URL_CMD_ENABLE;var xhr=new XMLHttpRequest();xhr.open('GET', url, true);xhr.onprogress=function(){updateStatus((disabled.checked ? 'Disabling' : 'Enabling')+' module...');};xhr.onload=function(){if(xhr.status==200){updateStatus('Module '+(disabled.checked ? 'disabled' : 'enabled'));}else{updateStatus('Fail '+(disabled.checked ? 'disabling' : 'enabling')+' module');}};xhr.send();}function readGpioData(){var xhr=new XMLHttpRequest();xhr.open('GET', URL_GPIO, true);xhr.onprogress=function(){updateStatus('Retrieving GPIOs states...');};xhr.onload=function(){if(xhr.status==200){var gpios=JSON.parse(xhr.response)['gpios'];for(var gpio in gpios){var gpioElmt=document.getElementById(gpio);var gpio_time=document.getElementById(gpio+'_time');if(gpio !='A0'){gpioElmt.checked=gpios[gpio]['state'];gpio_time.value=gpios[gpio]['time'];if(gpio_time.value>0){timed[gpio]=true;}}}}else{updateStatus('Fail connecting with module');}};xhr.send();}function readConfiguration(){var xhr=new XMLHttpRequest();xhr.open('GET', URL_CONF, true);xhr.onprogress=function(){updateStatus('Retrieving general configuration...');};xhr.onload=function(){if(xhr.status==200){var config=JSON.parse(xhr.response)['configuration'];if(config==false){updateStatus('Device has no configuration !');}else{document.getElementById('hostname').value=config['hostname'];document.getElementById('uptime').innerHTML=parseDuration(config['uptime']);document.getElementById('mac').innerHTML=config['mac'];document.getElementById('channel').innerHTML=config['channel'];document.getElementById('disabled').checked=config['disabled']==1;var wifi_mode=0;var wifimode=document.getElementsByName('wifimode');if(typeof config['ap'] !=='undefined'){wifi_mode=1;wifimode[1].checked=true;document.getElementById('ap_ssid').value=config['ap']['ssid'];document.getElementById('ap_pwd').value=config['ap']['password'];document.getElementById('ap_pwr').value=config['ap']['power'];document.getElementById('ap_ip').innerHTML=config['ap']['ip'];}if(typeof config['sta'] !=='undefined'){wifi_mode==0 ? wifimode[0].checked=true : wifimode[2].checked=true;document.getElementById('sta_ssid').value=config['sta']['ssid'];document.getElementById('rssi').innerHTML=config['sta']['rssi']+' dB';document.getElementById('bssid').innerHTML=config['sta']['bssid'];var ipmode=config['sta']['mode'];var ip_mode=document.getElementsByName('ipconfig');ipmode=='dhcp' ? ip_mode[0].checked=true : ip_mode[1].checked=true;if(ipmode=='static'){document.getElementById('ipaddr').value=config['sta']['ip'];document.getElementById('netmask').value=config['sta']['netmask'];document.getElementById('gateway').value=config['sta']['gateway'];document.getElementById('dns').value=config['sta']['dns'];}}}}else{updateStatus('Fail connecting with module');}hideFields();};xhr.send();}function decreaseTimer(){for(var gpio in timed){if(!timed[gpio]){continue;}var element=document.getElementById(gpio+'_time');if(element.value>0){element.value--;if(element.value==0){timed[gpio]=false;document.getElementById(gpio).checked=!document .getElementById(gpio).checked;}}}}function parseDuration(duration){var sec_num=parseInt(duration, 10);var hours=Math.floor(sec_num / 3600);var minutes=Math.floor((sec_num -(hours * 3600))/ 60);var seconds=sec_num -(hours * 3600)-(minutes * 60);if(hours<10){hours='0'+hours;}if(minutes<10){minutes='0'+minutes;}if(seconds<10){seconds='0'+seconds;}return hours+':'+minutes+':'+seconds;}</script></body></html>"));
}
